/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.midifile;

import com.softsynth.midifile.MIDIFileEvent;
import com.softsynth.midifile.MIDIFileInputStream;
import com.softsynth.midifile.MIDIFileListener;
import com.softsynth.midifile.MIDIFileMetaEvent;
import com.softsynth.midifile.MIDIFileOutput;
import com.softsynth.midifile.MIDIFileSysExEvent;
import com.softsynth.midifile.MIDIFileTrack;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class MIDIFileImage
implements MIDIFileListener {
    public MIDIFileTrack[] tracks;
    public int format;
    public short division;
    public int currentTrackIndex;
    public int ticksPerBeat;
    Vector tempoMap = new Vector();

    public double ticksToSeconds(int ticks) {
        double seconds = 0.0;
        double ticksPerMinute = 120.0 * (double)this.ticksPerBeat;
        seconds = (double)ticks * (60.0 / ticksPerMinute);
        Enumeration e = this.tempoMap.elements();
        while (e.hasMoreElements()) {
            TempoChange tc = (TempoChange)e.nextElement();
            if (tc.ticks > ticks) break;
            seconds = tc.ticksToSeconds(ticks);
        }
        return seconds;
    }

    @Override
    public void handleHeader(int format, int numTracks, short division) {
        this.format = format;
        this.tracks = new MIDIFileTrack[numTracks];
        this.division = division;
        if (division <= 0) {
            throw new RuntimeException("MIDIFile 'division' as time-code not supported.");
        }
        this.ticksPerBeat = division;
    }

    public MIDIFileTrack makeTrack() {
        return new MIDIFileTrack();
    }

    @Override
    public void handleBeginTrack(int index) {
        this.currentTrackIndex = index;
        this.tracks[index] = this.makeTrack();
    }

    @Override
    public void handleEndTrack(int index) {
        this.currentTrackIndex = -1;
    }

    @Override
    public void handleSysExF0(int ticks, byte[] b) {
        MIDIFileSysExEvent event = new MIDIFileSysExEvent(ticks, 240, b);
        this.tracks[this.currentTrackIndex].addEvent(event);
        event.setSeconds(this.ticksToSeconds(ticks));
    }

    @Override
    public void handleSysExF7(int ticks, byte[] b) {
        MIDIFileSysExEvent event = new MIDIFileSysExEvent(ticks, 247, b);
        this.tracks[this.currentTrackIndex].addEvent(event);
        event.setSeconds(this.ticksToSeconds(ticks));
    }

    @Override
    public void handleMetaEvent(int ticks, int type, byte[] b) {
        MIDIFileMetaEvent event = new MIDIFileMetaEvent(ticks, type, b);
        this.tracks[this.currentTrackIndex].addEvent(event);
        double seconds = this.ticksToSeconds(ticks);
        if (type == 81) {
            int microsPerBeat = ((b[0] & 0xFF) << 16) + ((b[1] & 0xFF) << 8) + (b[2] & 0xFF);
            TempoChange tc = new TempoChange(ticks, seconds, microsPerBeat, this.ticksPerBeat);
            this.tempoMap.addElement(tc);
        }
        event.setSeconds(seconds);
    }

    @Override
    public void handleEvent(int ticks, int command, int data1, int data2) {
        if ((command & 0xF0) == 144 && data2 == 0) {
            command = 0x80 | command & 0xF;
        }
        MIDIFileEvent event = new MIDIFileEvent(ticks, command, data1, data2);
        this.tracks[this.currentTrackIndex].addEvent(event);
        event.setSeconds(this.ticksToSeconds(ticks));
    }

    public void print() {
        System.out.println("MIDI File: format =" + this.format + ", numTracks = " + this.tracks.length + ", division = " + this.division);
        int i = 0;
        while (i < this.tracks.length) {
            System.out.println(" ============================== Track #" + i);
            this.tracks[i].print();
            ++i;
        }
    }

    public void write(MIDIFileOutput mfout) throws IOException {
        mfout.writeHeader(this.format, this.tracks.length, this.division);
        int i = 0;
        while (i < this.tracks.length) {
            this.tracks[i].write(mfout);
            ++i;
        }
    }

    public static void main(String[] args) {
        System.out.println("=============================================");
        MIDIFileImage.duplicateMIDIFile(args[0], args[1]);
    }

    static void duplicateMIDIFile(String inputName, String outputName) {
        try {
            try {
                FileInputStream stream = new FileInputStream(inputName);
                MIDIFileInputStream parser = new MIDIFileInputStream(stream);
                MIDIFileImage image = new MIDIFileImage();
                parser.addMIDIFileListener(image);
                parser.parse();
                parser.close();
                image.print();
                MIDIFileOutput mfout = new MIDIFileOutput(outputName);
                image.write(mfout);
                mfout.close();
                stream.close();
            }
            catch (FileNotFoundException e) {
                System.err.println(e);
            }
            catch (SecurityException e) {
                System.err.println(e);
            }
        }
        catch (IOException e) {
            System.err.println("Caught " + e);
            e.printStackTrace();
        }
    }

    static void printMIDIFile(String fileName) {
        try {
            try {
                FileInputStream stream = new FileInputStream(fileName);
                MIDIFileInputStream parser = new MIDIFileInputStream(stream);
                MIDIFileImage image = new MIDIFileImage();
                parser.addMIDIFileListener(image);
                parser.parse();
                parser.close();
                image.print();
            }
            catch (FileNotFoundException e) {
                System.err.println(e);
            }
            catch (SecurityException e) {
                System.err.println(e);
            }
        }
        catch (IOException e) {
            System.err.println("Caught " + e);
            e.printStackTrace();
        }
    }

    class TempoChange {
        public int ticks;
        public int microsPerBeat;
        double secondsPerTick;
        double seconds;

        public TempoChange(int ticks, double seconds, int microsPerBeat, int ticksPerBeat) {
            this.ticks = ticks;
            this.microsPerBeat = microsPerBeat;
            this.seconds = seconds;
            this.secondsPerTick = (double)microsPerBeat / (1000000.0 * (double)ticksPerBeat);
        }

        public double ticksToSeconds(int ticks) {
            return this.seconds + (double)(ticks - this.ticks) * this.secondsPerTick;
        }
    }
}

