/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.tools.view;

import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class JTextFieldDirty
extends JTextField {
    private boolean modified = false;

    public JTextFieldDirty(String text) {
        super(text);
        this.init();
    }

    public JTextFieldDirty(int columns) {
        super(columns);
        this.init();
    }

    public JTextFieldDirty(String text, int columns) {
        super(text, columns);
        this.init();
    }

    public JTextFieldDirty(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.init();
    }

    private void init() {
        this.setHorizontalAlignment(10);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                JTextFieldDirty.this.markDirty();
            }
        });
        this.markClean();
    }

    protected synchronized void markDirty() {
        if (!this.modified) {
            this.modified = true;
            this.setBackground(Color.pink);
            this.repaint();
        }
    }

    protected synchronized void markClean() {
        if (this.modified) {
            this.modified = false;
            this.setBackground(Color.white);
            this.setCaretPosition(0);
            this.repaint();
        }
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.markDirty();
    }

    @Override
    public String getText() {
        this.markClean();
        return super.getText();
    }
}

