/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.util;

import com.softsynth.util.TextOutput;
import com.softsynth.util.WildcardFilenameFilter;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class FileSearch {
    public static Vector expandFilenames(Vector filenames) {
        Vector expandedFilenames = new Vector();
        Enumeration e = filenames.elements();
        while (e.hasMoreElements()) {
            FileSearch.expandFilename((String)e.nextElement(), expandedFilenames);
        }
        return expandedFilenames;
    }

    public static void expandFilename(String filename, Vector expandedFilenames) {
        int lastSepPos = filename.lastIndexOf(File.separatorChar);
        int starPos = filename.indexOf(42);
        if (starPos < 0) {
            expandedFilenames.addElement(filename);
        } else if (starPos < lastSepPos) {
            TextOutput.error("Wildcard * not allowed in directory names! " + filename);
        } else {
            String[] files;
            String wildFile;
            String parent;
            if (lastSepPos < 0) {
                parent = ".";
                wildFile = filename;
            } else {
                parent = filename.substring(0, lastSepPos);
                wildFile = filename.substring(lastSepPos + 1);
            }
            File dir = new File(parent);
            if (!dir.exists()) {
                TextOutput.error("Invalid directory = " + parent);
            }
            if ((files = dir.list(new WildcardFilenameFilter(wildFile))) == null) {
                return;
            }
            int i = 0;
            while (i < files.length) {
                expandedFilenames.addElement(String.valueOf(parent) + File.separatorChar + files[i]);
                ++i;
            }
        }
    }

    public static String removeParent(String pathName) {
        int lastSepPos = pathName.lastIndexOf(File.separatorChar);
        if (lastSepPos < 0) {
            return pathName;
        }
        return pathName.substring(lastSepPos + 1);
    }

    public static String removeExtension(String pathName) {
        int lastDotPos = pathName.lastIndexOf(46);
        if (lastDotPos > 0) {
            return pathName.substring(0, lastDotPos);
        }
        return pathName;
    }

    public static void main(String[] args) {
        System.out.println("FileSearch - by Phil Burk");
        boolean result = WildcardFilenameFilter.wildMatch("abc*frog*xyz", "abctreefroglegxyz");
        System.out.println("result = " + result);
        result = WildcardFilenameFilter.wildMatch("abc*frog*xyz", "abctreefrxglegxyz");
        System.out.println("result = " + result);
        FileSearch.test();
    }

    static void test() {
        Vector expandedFilenames = new Vector();
        FileSearch.expandFilename("../data/ov*.mid", expandedFilenames);
        Enumeration e = expandedFilenames.elements();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            System.out.println("file = " + name);
        }
    }

    public static void createDirectoryIfNeeded(String directoryName) throws SecurityException {
        FileSearch.createDirectoryIfNeeded(new File(directoryName));
    }

    public static void createDirectoryIfNeeded(File dir) throws SecurityException {
        if (!dir.isDirectory() && !dir.mkdirs()) {
            TextOutput.error("Could not make output directory " + dir.getAbsolutePath());
        }
    }
}

