/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.jsyn.SynthPort;
import com.softsynth.util.IndentingWriter;
import com.softsynth.wire.ExternalPortModule;
import com.softsynth.wire.Module;
import com.softsynth.wire.OutputSynthWireJack;
import com.softsynth.wire.SynthWireJack;
import com.softsynth.wire.Wire;
import com.softsynth.wire.WireJack;
import java.awt.Color;
import java.io.IOException;

abstract class ExternalQueuePort
extends ExternalPortModule {
    @Override
    WireJack getJack(String name, int partIndex) {
        return super.getJack("output", partIndex);
    }

    public void setupJacks(Color color, int supportMask) {
        this.portJack = new OutputSynthWireJack((Module)this, "output", null);
        this.portJack.getComponent().setBackground(color);
        this.portJack.setMaxConnected(1);
        this.portJack.setSupportMask(supportMask);
        this.addJackCanvas(this.portJack);
        this.addJackToPatch();
        this.setName(this.getName());
    }

    abstract void addJackToPatch();

    @Override
    void halfConnect(WireJack myJack, WireJack otherJack) {
        super.halfConnect(myJack, otherJack);
        if (myJack == this.portJack) {
            ((SynthWireJack)this.exportedJack).setSynthPort(((SynthWireJack)otherJack).getSynthPort());
        }
    }

    @Override
    void halfDisconnect(WireJack myJack, WireJack otherJack) {
        super.halfDisconnect(myJack, otherJack);
        if (myJack == this.portJack) {
            ((SynthWireJack)this.exportedJack).setSynthPort(null);
        }
    }

    @Override
    public void generateSource(IndentingWriter writer, int phase) throws IOException {
        int numConnected = this.portJack.getConnectedCount();
        if (numConnected == 0) {
            return;
        }
        String name = this.getName();
        switch (phase) {
            case 0: {
                SynthWireJack swPort = (SynthWireJack)this.portJack.getConnected(0);
                SynthPort sPort = swPort.getSynthPort();
                String className = Wire.stripJSynPackage(sPort.getClass().getName());
                writer.println("public " + className + " " + name + ";");
                break;
            }
            case 2: {
                SynthWireJack other = (SynthWireJack)this.portJack.getConnected(0);
                writer.println("addPort( " + name + " = " + other.getSourceName() + ", \"" + name + "\" );");
            }
        }
    }
}

