/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.tools.view.EditableRotaryKnob;
import com.softsynth.view.ValueController;
import com.softsynth.wire.NumericValueModule;
import com.softsynth.wire.Wire;
import com.softsynth.wire.WireJack;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

class NumericKnobModule
extends NumericValueModule {
    JPanel topPanel;

    @Override
    public void calculateSize() {
        this.panel.setSize(65, 100);
    }

    @Override
    public ValueController makeValueController() {
        EditableRotaryKnob knob = new EditableRotaryKnob(null, 0.0, 0.0, 1.0, 6);
        knob.setBackground(Wire.KNOB_BACKGROUND_COLOR);
        return knob;
    }

    @Override
    void arrangeComponents(Component dragger, Component connector) {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        this.panel.add((Component)this.topPanel, "North");
        this.topPanel.add(dragger, "Center");
        this.topPanel.add(connector, "East");
    }

    @Override
    void halfConnect(WireJack myJack, WireJack otherJack) {
        super.halfConnect(myJack, otherJack);
        String otherName = otherJack.getName();
        if (otherName.length() > 7) {
            otherName = otherName.substring(0, 7);
        }
        this.dragger.setText(otherName);
    }
}

