/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.wire.Module;
import com.softsynth.wire.PatchPanel;
import com.softsynth.wire.WireJack;
import com.softsynth.wire.WireUpdater;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

abstract class WireJackEditor
extends JDialog {
    Module module;
    WireJack port;
    private JPanel editorsPanel;
    Vector subEditors;
    JButton okButton;
    JButton cancelButton;
    public static final int CANCEL = 0;
    public static final int OK = 1;
    int answer = 0;

    public WireJackEditor(Frame frame, Module module, WireJack port) {
        super(frame, "Please initialize module.", true);
        this.module = module;
        this.getContentPane().setLayout(new BorderLayout());
        this.subEditors = new Vector();
        Panel panel = new Panel();
        this.getContentPane().add("South", panel);
        this.okButton = new JButton("OK");
        panel.add(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WireJackEditor.this.handleOK();
            }
        });
        this.cancelButton = new JButton("Cancel");
        panel.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WireJackEditor.this.answer = 0;
                WireJackEditor.this.setVisible(false);
            }
        });
        this.addSubEditors(module, port);
        this.validate();
        this.pack();
    }

    void addSubEditor(WireUpdater editor) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.subEditors.addElement(editor);
        panel.add("North", (Component)((Object)editor));
        if (this.editorsPanel == null) {
            this.getContentPane().add("Center", panel);
        } else {
            this.editorsPanel.add("Center", panel);
        }
        this.editorsPanel = panel;
    }

    abstract void addSubEditors(Module var1, WireJack var2);

    void handleOK() {
        boolean bad = false;
        Enumeration e = this.subEditors.elements();
        while (e.hasMoreElements()) {
            WireUpdater editor = (WireUpdater)e.nextElement();
            bad |= editor.applyEdit();
        }
        if (!bad) {
            this.answer = 1;
            this.setVisible(false);
            PatchPanel pp = this.module.getPatch().getPatchPanel();
            if (pp != null) {
                pp.repaint();
            }
        }
    }

    @Override
    public void show() {
        Enumeration e = this.subEditors.elements();
        while (e.hasMoreElements()) {
            WireUpdater updater = (WireUpdater)e.nextElement();
            updater.update();
        }
        super.show();
    }

    int ask() {
        this.show();
        return this.answer;
    }
}

