/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class LabelledCanvas
extends JComponent {
    private static final long serialVersionUID = 1L;
    boolean highlighted = false;
    private String text = "?";
    private int alignment = 2;

    public LabelledCanvas(String text) {
        this.setFont(new Font("Verdana", 0, 12));
        this.setText(text);
    }

    public LabelledCanvas() {
        this(null);
    }

    public void setText(String text) {
        this.text = text;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setHighlighted(boolean flag) {
        this.highlighted = flag;
        this.repaint();
    }

    public boolean getHighlighted() {
        return this.highlighted;
    }

    @Override
    public void paint(Graphics g) {
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        g.setColor(this.getHighlighted() ? this.getForeground() : this.getBackground());
        g.fillRect(1, 1, width - 2, height - 2);
        this.drawUnderText(g);
        String txt = this.getText();
        if (txt != null) {
            g.setColor(this.getHighlighted() ? this.getBackground() : this.getForeground());
            int x = 3;
            if (this.alignment == 0) {
                x = (width - this.computeTextWidth(g)) / 2;
                if (x < 3) {
                    x = 3;
                }
            } else if (this.alignment == 4 && (x = width - this.computeTextWidth(g) - 6) < 3) {
                x = 3;
            }
            g.drawString(txt, x, height - 4);
        }
        g.setColor(this.getForeground());
        g.drawRect(1, 1, width - 2, height - 2);
    }

    private int computeTextWidth(Graphics g) {
        FontMetrics fontMetrics = g.getFontMetrics();
        return SwingUtilities.computeStringWidth(fontMetrics, this.text);
    }

    public void drawUnderText(Graphics g) {
    }
}

