/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import com.syntona.gui.LogWindow;
import com.syntona.gui.patch.ModulePickerTree;
import com.syntona.gui.patch.PatchEditor;
import com.syntona.gui.patch.PatchFrame;
import com.syntona.model.SyntonaEngine;
import com.syntona.model.core.PatchModulePresenter;
import com.syntona.plugin.Bundle;
import com.syntona.plugin.EngineController;
import com.syntona.plugin.ModuleInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JDesktopPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.xml.parsers.ParserConfigurationException;

public class TopPatchEditor
extends JPanel {
    private static final int DEFAULT_HEIGHT = 600;
    private static final int DEFAULT_WIDTH = 800;
    private EngineController engine;
    private PatchModulePresenter topPatchPresenter;
    private PatchModulePresenter frontPatchPresenter;
    private JDesktopPane desktop;
    private PatchEditor frontPatchEditor;
    private LogWindow logWindow;
    private JSplitPane splitPane;
    private ModulePickerTree modulePicker;

    public TopPatchEditor(EngineController engine) {
        this.engine = engine;
        this.setLayout(new BorderLayout());
        this.topPatchPresenter = engine.getTopPatch();
        this.desktop = new JDesktopPane();
        this.modulePicker = new ModulePickerTree(engine, this);
        Dimension minimumSize = new Dimension(100, 50);
        this.desktop.setMinimumSize(minimumSize);
        this.modulePicker.setMinimumSize(minimumSize);
        this.splitPane = new JSplitPane(1, this.modulePicker, this.desktop);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(200);
        this.add((Component)this.splitPane, "Center");
        this.openPatchFrame(this.topPatchPresenter);
        this.setFrontPatchPresenter(this.topPatchPresenter);
        this.logWindow = new LogWindow();
        this.desktop.add(this.logWindow);
    }

    public void addMenus(JMenuBar menuBar) {
        JMenu moduleMenu = new JMenu("Modules");
        for (Bundle bundle : this.engine.getBundles()) {
            JMenu item = this.makeBundleMenu(bundle);
            moduleMenu.add(item);
        }
        menuBar.add(moduleMenu);
    }

    private JMenu makeBundleMenu(Bundle bundle) {
        HashMap<String, JMenu> groupMap = new HashMap<String, JMenu>();
        JMenu bundleMenu = new JMenu(bundle.getName());
        Iterator<ModuleInfo> infos = bundle.getModuleInfos();
        while (infos.hasNext()) {
            ModuleInfo moduleInfo = infos.next();
            JMenuItem item = new JMenuItem(new ModuleMenuAction(moduleInfo));
            String groupName = moduleInfo.getGroup();
            if (groupName != null) {
                JMenu groupMenu = (JMenu)groupMap.get(groupName);
                if (groupMenu == null) {
                    groupMenu = new JMenu(groupName);
                    groupMap.put(groupName, groupMenu);
                    bundleMenu.add(groupMenu);
                }
                groupMenu.add(item);
                continue;
            }
            bundleMenu.add(item);
        }
        return bundleMenu;
    }

    public PatchModulePresenter getFrontPatchPresenter() {
        return this.frontPatchPresenter;
    }

    public void setFrontPatchPresenter(PatchModulePresenter frontPatchPresenter) {
        this.frontPatchPresenter = frontPatchPresenter;
        SyntonaEngine.getInstance().setFrontPatchPresenter(frontPatchPresenter);
    }

    public PatchFrame openPatchFrame(final PatchModulePresenter patchModulePresenter) {
        final PatchFrame patchFrame = new PatchFrame(this.engine, this, patchModulePresenter);
        int x = 20;
        int y = 20;
        if (this.frontPatchPresenter != null) {
            PatchFrame frontFrame = this.frontPatchPresenter.getPatchFrame();
            x = frontFrame.getX() + 20;
            y = frontFrame.getY() + 20;
        }
        patchFrame.setLocation(x, y);
        patchFrame.setSize(800, 600);
        patchFrame.setVisible(true);
        this.desktop.add(patchFrame);
        patchFrame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameOpened(InternalFrameEvent arg0) {
                PatchFrame patchFrame2 = (PatchFrame)arg0.getSource();
                TopPatchEditor.this.setFrontPatchFrame(patchFrame2);
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent arg0) {
                PatchFrame patchFrame2 = (PatchFrame)arg0.getSource();
                TopPatchEditor.this.setFrontPatchFrame(patchFrame2);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
                TopPatchEditor.this.frontPatchEditor = null;
                TopPatchEditor.this.setFrontPatchPresenter(null);
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                boolean cancel = false;
                if (patchModulePresenter == TopPatchEditor.this.topPatchPresenter) {
                    try {
                        cancel = TopPatchEditor.this.engine.saveTopIfDirty();
                    }
                    catch (ParserConfigurationException e1) {
                        e1.printStackTrace();
                        cancel = true;
                    }
                    if (!cancel) {
                        TopPatchEditor.this.engine.sendClearTopPatch();
                    }
                }
                if (!cancel) {
                    TopPatchEditor.this.frontPatchEditor = null;
                    TopPatchEditor.this.setFrontPatchPresenter(null);
                    patchFrame.hide();
                    TopPatchEditor.this.desktop.repaint();
                }
            }
        });
        patchFrame.moveToFront();
        return patchFrame;
    }

    public void setFrontPatchFrame(PatchFrame patchFrame) {
        this.frontPatchEditor = patchFrame.getPatchEditor();
        this.setFrontPatchPresenter(patchFrame.getPatchModulePresenter());
        patchFrame.updateTitle();
        patchFrame.repaint();
    }

    public PatchEditor getFrontPatchEditor() {
        return this.frontPatchEditor;
    }

    public void addModuleToFrontPatch(ModuleInfo moduleInfo) {
        if (this.frontPatchPresenter != null) {
            this.engine.sendAddModule(moduleInfo.getBundle(), this.frontPatchPresenter, moduleInfo.getType());
        } else {
            System.err.println("Cannot add module! No frontPatchPresenter");
        }
    }

    class ModuleMenuAction
    extends AbstractAction {
        ModuleInfo moduleInfo;

        public ModuleMenuAction(ModuleInfo moduleInfo) {
            super(moduleInfo.getType());
            this.moduleInfo = moduleInfo;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            TopPatchEditor.this.addModuleToFrontPatch(this.moduleInfo);
        }
    }
}

