/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitPort;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.util.IndentingWriter;
import com.syntona.model.SyntonaExporter;
import com.syntona.model.jsyn.AudioJack;
import com.syntona.model.jsyn.OutputAudioJack;
import com.syntona.plugin.InputDoubleJack;
import com.syntona.plugin.Jack;
import com.syntona.plugin.SyntonaModule;
import java.awt.Color;
import java.lang.reflect.Field;

public class InputAudioJack
extends InputDoubleJack
implements AudioJack {
    private UnitInputPort port;
    private int partIndex;
    private static Color JACK_COLOR = new Color(200, 255, 200);

    public InputAudioJack(SyntonaModule module, String name, String help) {
        super(module, name, help);
    }

    public InputAudioJack(SyntonaModule syntonaModule, String fieldName, UnitInputPort port, int partIndex) {
        this(syntonaModule, fieldName, "generic JSyn unit");
        this.port = port;
        this.partIndex = partIndex;
        this.setMin(port.getMinimum());
        this.setMax(port.getMaximum());
    }

    @Override
    public Color getColor() {
        return JACK_COLOR;
    }

    @Override
    public UnitPort getSynthPort() {
        return this.port;
    }

    public void setUnitInputPort(UnitInputPort port) {
        this.port = port;
    }

    public UnitInputPort getUnitInputPort() {
        return this.port;
    }

    @Override
    public void setPartIndex(int j) {
        this.partIndex = j;
        super.setValue(this.port.getValue(j));
    }

    @Override
    public int getPartIndex() {
        return this.partIndex;
    }

    @Override
    public String getValueText() {
        return "" + this.port.getValue(this.partIndex);
    }

    @Override
    public void removeConnection(Jack other) {
        super.removeConnection(other);
        if (other instanceof OutputAudioJack) {
            OutputAudioJack otherAudioJack = (OutputAudioJack)other;
            UnitOutputPort otherUnitBlockPort = otherAudioJack.getSynthPort();
            otherUnitBlockPort.disconnect(otherAudioJack.getPartIndex(), (UnitInputPort)this.getSynthPort(), this.partIndex);
        }
    }

    @Override
    public void addConnection(Jack other) {
        super.addConnection(other);
        if (other instanceof AudioJack) {
            AudioJack source = (AudioJack)((Object)other);
            UnitInputPort thisInput = this.port;
            if (source.getSynthPort() instanceof UnitOutputPort) {
                ((UnitOutputPort)source.getSynthPort()).connect(source.getPartIndex(), thisInput, this.getPartIndex());
            } else {
                throw new RuntimeException("Cannot connect these together. UNIMPLEMENTED");
            }
        }
    }

    @Override
    public double getValue() {
        return this.port.get(this.partIndex);
    }

    @Override
    public void setValue(double d) {
        this.port.set(this.partIndex, d);
        super.setValue(d);
    }

    @Override
    public void setMin(double min) {
        this.port.setMinimum(min);
        super.setMin(min);
    }

    @Override
    public void setMax(double max) {
        this.port.setMaximum(max);
        super.setMax(max);
    }

    @Override
    public void exportJavaSource(SyntonaExporter exporter, int phase) {
        switch (phase) {
            case 5: {
                boolean isConnected = this.port.isConnected(this.partIndex);
                IndentingWriter writer = exporter.getWriter();
                String thisName = this.getExportablePortName();
                if (isConnected) break;
                if (this.partIndex == 0) {
                    writer.println(String.valueOf(this.getModule().getExportName()) + "." + thisName + ".set(" + this.port.getValue(this.partIndex) + ");");
                    break;
                }
                writer.println(String.valueOf(this.getModule().getExportName()) + "." + thisName + ".set(" + this.partIndex + ", " + this.port.getValue(this.partIndex) + ");");
            }
        }
    }

    String getExportablePortName() {
        return InputAudioJack.getExportablePortName(this.port);
    }

    public static String getExportablePortName(UnitPort port) {
        Field[] fields;
        String name = port.getName();
        UnitGenerator unit = port.getUnitGenerator();
        Field[] fieldArray = fields = unit.getClass().getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                UnitPort somePort = (UnitPort)field.get(unit);
                if (somePort == port) {
                    name = field.getName();
                    break;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return name;
    }

    String getPortName() {
        return this.port.getName();
    }
}

