/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import com.syntona.gui.patch.InputDoubleJackEditor;
import com.syntona.model.SyntonaSaver;
import com.syntona.model.XMLDOMLoader;
import com.syntona.plugin.InputJack;
import com.syntona.plugin.Jack;
import com.syntona.plugin.JackBoundedRangeModel;
import com.syntona.plugin.JackEditor;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.OutputJack;
import com.syntona.plugin.PatchMessage;
import com.syntona.plugin.PatchMessageDouble;
import com.syntona.plugin.SyntonaModule;
import javax.swing.BoundedRangeModel;
import org.w3c.dom.Element;

public class InputDoubleJack
extends InputJack {
    private double DEFAULT_MIN;
    private double min;
    private double DEFAULT_MAX;
    private double max;
    private double value;
    private BoundedRangeModel boundedRangeModel;

    @Override
    public void loadContents(Element jackElement) {
        this.setMin(XMLDOMLoader.parseDoubleAttribute(jackElement, "min"));
        this.setMax(XMLDOMLoader.parseDoubleAttribute(jackElement, "max"));
        this.setValue(XMLDOMLoader.parseDoubleAttribute(jackElement, "value"));
    }

    @Override
    public void save(SyntonaSaver saver) {
        saver.beginElement("jack");
        saver.addAttribute("name", this.name);
        saver.addAttribute("min", "" + this.min);
        saver.addAttribute("max", "" + this.max);
        saver.addAttribute("value", "" + this.value);
        saver.endElement();
    }

    public InputDoubleJack(SyntonaModule module, String name) {
        this(module, name, "");
    }

    public InputDoubleJack(SyntonaModule module, String name, String help) {
        super(module, name, help);
        this.min = this.DEFAULT_MIN = 0.0;
        this.max = this.DEFAULT_MAX = 100.0;
        this.value = this.DEFAULT_MIN;
    }

    @Override
    public void passMessage(PatchMessage msg) {
        if (msg instanceof PatchMessageDouble) {
            double v = ((PatchMessageDouble)msg).getValue();
            this.setValue(v);
        }
        super.passMessage(msg);
    }

    @Override
    public boolean willAccept(Jack other) {
        if (other instanceof OutputJack) {
            OutputJack otherOutputJack = (OutputJack)other;
            return super.willAccept(other) && !this.detectRecursion(otherOutputJack);
        }
        return false;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
        this.fireChangeListeners();
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setBoundedRangeModel(BoundedRangeModel model) {
        this.boundedRangeModel = model;
    }

    public BoundedRangeModel getBoundedRangeModel() {
        if (this.boundedRangeModel == null) {
            this.boundedRangeModel = new JackBoundedRangeModel(this);
        }
        return this.boundedRangeModel;
    }

    @Override
    public String getValueText() {
        return "" + this.getValue();
    }

    @Override
    public JackEditor getEditor(ModulePresenter modulePresenter) {
        return new InputDoubleJackEditor(this, modulePresenter);
    }
}

