/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import com.syntona.plugin.SyntonaModelListener;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class SyntonaModel {
    protected String name = "Unnamed";
    private String help = "";
    private CopyOnWriteArrayList<SyntonaModelListener> listeners = new CopyOnWriteArrayList();

    public SyntonaModel() {
    }

    public SyntonaModel(String name, String help) {
        this.name = name;
        this.help = help;
    }

    private void fireNameChanged() {
        for (SyntonaModelListener modelListener : this.listeners) {
            modelListener.nameChanged(this);
        }
    }

    public void fireOnOffChanged(boolean onOrOff) {
        for (SyntonaModelListener modelListener : this.listeners) {
            modelListener.onOffChanged(this, onOrOff);
        }
    }

    public void addModelListener(SyntonaModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(SyntonaModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fireNameChanged();
    }

    public String getToolTipText() {
        return String.valueOf(this.name) + ", " + this.help;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }
}

