/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.admin;

import com.transjam.admin.AdminAdapter;
import com.transjam.admin.Administrator;
import com.transjam.admin.ClientStatusPanel;
import com.transjam.admin.MemoryStatusPanel;
import com.transjam.admin.ShutdownPanel;
import com.transjam.client.Client;
import java.awt.Button;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

public class AdminControlPanel
extends Panel {
    Administrator admin;
    AdminAdapter adminAdapter;
    Button updateButton;
    ShutdownPanel shutdownPanel;
    ClientStatusPanel clientStatusPanel;
    MemoryStatusPanel memoryStatusPanel;
    Label statusLabel;
    Label broadcastLabel;
    TextField broadcastField;
    int durationMSec = 2000;
    UpdateStatusThread updateThread;

    public AdminControlPanel(Administrator pClient) {
        this.admin = pClient;
        this.setLayout(new GridLayout(0, 1));
        this.statusLabel = new Label("Server running.", 1);
        this.add(this.statusLabel);
        Panel statusPanel = new Panel();
        statusPanel.setLayout(new GridLayout(1, 2));
        this.add(statusPanel);
        this.clientStatusPanel = new ClientStatusPanel();
        statusPanel.add(this.clientStatusPanel);
        this.memoryStatusPanel = new MemoryStatusPanel();
        statusPanel.add(this.memoryStatusPanel);
        this.broadcastLabel = new Label("___ broadcast messages ____", 1);
        this.add(this.broadcastLabel);
        Panel p = new Panel();
        this.add(p);
        p.add(new Label("Type Broadcast Here:"));
        this.broadcastField = new TextField(40);
        p.add(this.broadcastField);
        this.broadcastField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = AdminControlPanel.this.broadcastField.getText();
                try {
                    if (text.length() > 0) {
                        AdminControlPanel.this.admin.broadcast(text);
                    }
                    AdminControlPanel.this.broadcastField.setText("");
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        });
        this.shutdownPanel = new ShutdownPanel(this.admin);
        this.add(this.shutdownPanel);
        this.adminAdapter = new AdminAdapter(){

            @Override
            public void reportedMemory(int free, int total) {
                AdminControlPanel.this.memoryStatusPanel.setFree(free);
                AdminControlPanel.this.memoryStatusPanel.setTotal(total);
            }

            @Override
            public void reportedClients(int current, int accepted, int denied, int max, int encountered, int broken, double seconds) {
                AdminControlPanel.this.clientStatusPanel.setCurrent(current);
                AdminControlPanel.this.clientStatusPanel.setAccepted(accepted);
                AdminControlPanel.this.clientStatusPanel.setDenied(denied);
                AdminControlPanel.this.clientStatusPanel.setEncountered(encountered);
                AdminControlPanel.this.clientStatusPanel.setBroken(broken);
                AdminControlPanel.this.clientStatusPanel.setClientSeconds(seconds);
            }

            @Override
            public void serverDown(Client client) {
                AdminControlPanel.this.statusLabel.setText("SERVER DISCONNECTED!!");
                AdminControlPanel.this.statusLabel.setForeground(Color.red);
                AdminControlPanel.this.validate();
            }

            @Override
            public void sentBroadcast(String text) {
                AdminControlPanel.this.broadcastLabel.setText(text);
                AdminControlPanel.this.validate();
            }
        };
    }

    public void start() {
        this.stop();
        this.admin.addMessageListener(this.adminAdapter);
        this.updateThread = new UpdateStatusThread();
        this.updateThread.start();
    }

    public void stop() {
        this.admin.removeMessageListener(this.adminAdapter);
        if (this.updateThread != null) {
            this.updateThread.go = false;
            this.updateThread = null;
        }
    }

    class UpdateStatusThread
    extends Thread {
        public volatile boolean go = true;

        UpdateStatusThread() {
        }

        @Override
        public void run() {
            while (this.go) {
                if (AdminControlPanel.this.admin.getSocket() == null) {
                    System.out.println("UpdateStatusThread: socket is null.");
                    break;
                }
                try {
                    AdminControlPanel.this.admin.queryAll();
                }
                catch (IOException exc) {
                    AdminControlPanel.this.statusLabel.setText("IO error getting server status!");
                    break;
                }
                try {
                    UpdateStatusThread.sleep(AdminControlPanel.this.durationMSec);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

