/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;

public abstract class CheckCountGrid
extends Canvas {
    int numRows;
    int numColumns;
    int minRowSize = 16;
    int minColumnSize = 20;
    int inset = 4;
    Vector listeners;
    boolean[] enables;
    boolean[] states;
    int[] counts;
    boolean useFixedWidth = false;

    public CheckCountGrid(int pNumRows, int pNumColumns) {
        this.numRows = pNumRows;
        this.setNumColumns(pNumColumns);
        int numElements = this.numRows * this.numColumns;
        this.enables = new boolean[numElements];
        this.states = new boolean[numElements];
        this.counts = new int[numElements];
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                CheckCountGrid.this.processMouse(e.getX(), e.getY());
            }
        });
    }

    public int rowColumnToIndex(int row, int column) {
        return column + row * this.numColumns;
    }

    public int getCount(int row, int column) {
        return this.counts[this.rowColumnToIndex(row, column)];
    }

    public void setCount(int index, int count) {
        if (index >= 0 && index < this.counts.length) {
            this.counts[index] = count;
            this.repaint();
        }
    }

    private void processMouse(int x, int y) {
        int column = this.xToColumn(x);
        int row = this.yToRow(y);
        if (this.getEnabled(row, column) && column < this.numColumns && row < this.numRows) {
            this.setState(row, column, !this.getState(row, column));
        }
    }

    @Override
    public void setEnabled(boolean flag) {
        int i = 0;
        while (i < this.enables.length) {
            this.enables[i] = flag;
            ++i;
        }
    }

    public void setEnabled(int index, boolean flag) {
        this.enables[index] = flag;
        this.repaint();
    }

    public boolean getEnabled(int row, int column) {
        return this.enables[this.rowColumnToIndex(row, column)];
    }

    public void setState(int row, int column, boolean flag) {
        this.states[this.rowColumnToIndex((int)row, (int)column)] = flag;
        this.repaint();
    }

    public void setState(int index, boolean flag) {
        this.states[index] = flag;
        this.repaint();
    }

    public boolean getState(int row, int column) {
        return this.states[this.rowColumnToIndex(row, column)];
    }

    public boolean getState(int index) {
        return this.states[index];
    }

    public void setNumColumns(int pNumColumns) {
        this.numColumns = pNumColumns;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public int getNumElements() {
        return this.numRows * this.numColumns;
    }

    int columnToX(int column) {
        int width = this.getBounds().width;
        int x = this.useFixedWidth ? column * (width / this.numColumns) : width * column / this.numColumns;
        return x;
    }

    int xToColumn(int x) {
        int col;
        int width = this.getBounds().width;
        if (this.useFixedWidth) {
            int colWidth = width / this.numColumns;
            col = x / colWidth;
        } else {
            col = x * this.numColumns / width;
        }
        if (col >= this.numColumns) {
            col = this.numColumns;
        } else if (col < 0) {
            col = 0;
        }
        return col;
    }

    int yToRow(int y) {
        int height = this.getBounds().height;
        int rowHeight = height / this.numRows;
        int row = y / rowHeight;
        if (row >= this.numRows) {
            row = this.numRows;
        }
        return row;
    }

    int rowToY(int column) {
        int height = this.getBounds().height;
        int rowHeight = height / this.numRows;
        return column * rowHeight;
    }

    @Override
    public void paint(Graphics g) {
        int y;
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        int rowHeight = height / this.numRows;
        int x1 = this.columnToX(0);
        int j = 0;
        while (j < this.numColumns) {
            int x2 = this.columnToX(j + 1);
            int boxX1 = x1 + this.inset;
            int boxX2 = x2 - this.inset;
            int i = 0;
            while (i < this.numRows) {
                y = rowHeight * i;
                int boxY1 = y + this.inset;
                int boxY2 = y + rowHeight / 2;
                int count = this.getCount(i, j);
                g.setColor(this.getEnabled(i, j) ? Color.white : Color.gray);
                g.fillRect(boxX1, boxY1, boxX2 - boxX1, boxY2 - boxY1);
                g.setColor(this.getForeground());
                if (this.getState(i, j)) {
                    g.drawLine(boxX1, boxY1, boxX2 - 1, boxY2);
                    g.drawLine(boxX1, boxY2, boxX2 - 1, boxY1);
                }
                g.setColor(count > 0 ? Color.red : this.getForeground());
                g.drawString(Integer.toString(count), boxX1, y + rowHeight - this.inset);
                ++i;
            }
            x1 = x2;
            ++j;
        }
        g.setColor(this.getForeground());
        y = this.numRows * rowHeight;
        j = 0;
        while (j <= this.numColumns) {
            x1 = this.columnToX(j);
            g.drawLine(x1, 0, x1, y);
            ++j;
        }
        y = 0;
        int i = 0;
        while (i <= this.numRows) {
            g.drawLine(0, y, width, y);
            y += rowHeight;
            ++i;
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.numColumns * this.minColumnSize, this.numRows * this.minRowSize);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

