/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.awt;

import com.transjam.awt.ContainerHack;
import com.transjam.awt.LobbyPanel;
import com.transjam.awt.LoginPanel;
import com.transjam.client.Client;
import com.transjam.client.ClientAdapter;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.io.IOException;

public class LoginLobbyPanel
extends Panel {
    private Client client;
    private ClientAdapter loginAdapter;
    private ClientAdapter lobbyAdapter;
    private LoginPanel loginPanel;
    private LobbyPanel lobbyPanel;
    private String lobbyName;
    private Label topLabel;

    public LoginLobbyPanel(Frame frame, Client pClient, String pLobbyName, int pMaxClientsPerRoom) {
        this.client = pClient;
        this.lobbyName = pLobbyName;
        this.setLayout(new BorderLayout());
        this.topLabel = new Label("TransJam Login", 1);
        this.topLabel.setFont(new Font("Serif", 1, 18));
        this.add("North", this.topLabel);
        this.loginPanel = new LoginPanel(this.client);
        this.add("Center", this.loginPanel);
        this.lobbyPanel = new LobbyPanel(frame, this.client, pMaxClientsPerRoom);
        this.loginAdapter = new ClientAdapter(){

            @Override
            public void deniedLogin(String reason) {
                LoginLobbyPanel.this.remove(LoginLobbyPanel.this.loginPanel);
                LoginLobbyPanel.this.syncContainer();
                LoginLobbyPanel.this.topLabel.setText("Login denied: " + reason);
            }

            @Override
            public void grantedLogin(int uid) throws IOException {
                LoginLobbyPanel.this.remove(LoginLobbyPanel.this.loginPanel);
                LoginLobbyPanel.this.client.joinRoom(LoginLobbyPanel.this.lobbyName);
            }
        };
        this.lobbyAdapter = new ClientAdapter(){

            @Override
            public void enteredRoom(String name, int level) throws IOException {
                if (!LoginLobbyPanel.this.isAncestorOf(LoginLobbyPanel.this.lobbyPanel)) {
                    LoginLobbyPanel.this.add("Center", LoginLobbyPanel.this.lobbyPanel);
                    LoginLobbyPanel.this.syncContainer();
                }
            }

            @Override
            public void exitedRoom(String name, int level) throws IOException {
                LoginLobbyPanel.this.remove(LoginLobbyPanel.this.lobbyPanel);
            }
        };
    }

    private void syncContainer() {
        ContainerHack.syncContainer(this);
    }

    public Client getClient() {
        return this.client;
    }

    public void start() {
        this.stop();
        this.lobbyPanel.start();
        this.client.addMessageListener(this.loginAdapter, 0);
        this.client.addMessageListener(this.lobbyAdapter, 1);
    }

    public void stop() {
        this.lobbyPanel.stop();
        this.client.removeMessageListener(this.loginAdapter, 0);
        this.client.removeMessageListener(this.lobbyAdapter, 1);
    }
}

