/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.client;

import com.transjam.client.Client;
import com.transjam.client.TransjamMessageListener;
import com.transjam.util.TransjamMessage;
import java.io.IOException;
import java.util.Date;

public class ClientAdapter
implements TransjamMessageListener {
    public void grantedLogin(int uid) throws IOException {
    }

    public void addedRoom(String name, int numClients, int maxClients) throws IOException {
    }

    public void updatedRoom(String name, int numClients, int maxClients) throws IOException {
    }

    public void deletedRoom(String name) throws IOException {
    }

    public void enteredRoom(String name, int level) throws IOException {
    }

    public void exitedRoom(String name, int level) throws IOException {
    }

    public void deniedRoom(String name) throws IOException {
    }

    public void sentChat(int uid, int flags, String text) throws IOException {
    }

    public void sentBroadcast(String text) throws IOException {
    }

    public void sentSelf(String text) throws IOException {
    }

    public void sentAll(int uid, String text) throws IOException {
    }

    public void sentOthers(int uid, String text) throws IOException {
    }

    public void addedUser(int uid, String name) throws IOException {
    }

    public void deletedUser(int uid, String name) throws IOException {
    }

    public void modifiedThing(String name, String content) throws IOException {
    }

    public void grantedLock(String name, int uid) throws IOException {
    }

    public void deniedLock(String name, int uid) throws IOException {
    }

    public void unlockedThing(String name) throws IOException {
    }

    public void askedForLock(String name) throws IOException {
    }

    @Override
    public void serverDown(Client client) {
    }

    public void endedList() throws IOException {
    }

    public void gotTime(Date when) throws IOException {
    }

    public void addedMeeting(Date when, int numClients) throws IOException {
    }

    public void gotUserLocation(int uid, double latitude, double longitude) throws IOException {
    }

    public void deniedLogin(String reason) {
        System.out.println("deniedLogin: why are we here?");
    }

    @Override
    public boolean handleMessage(Client client, TransjamMessage message) throws IOException {
        boolean result = true;
        if (message.command.equals("modifything")) {
            String name = message.get("name");
            this.modifiedThing(name, message.content);
        } else if (message.command.equals("sendself")) {
            this.sentSelf(message.content);
        } else if (message.command.equals("sendall")) {
            int uid = message.get("uid", 0);
            this.sentAll(uid, message.content);
        } else if (message.command.equals("sendothers")) {
            int uid = message.get("uid", 0);
            this.sentOthers(uid, message.content);
        } else if (message.command.equals("grantlock")) {
            this.grantedLock(message.get("name"), message.get("uid", 0));
        } else if (message.command.equals("denylock")) {
            this.deniedLock(message.get("name"), message.get("uid", 0));
        } else if (message.command.equals("unlockthing")) {
            this.unlockedThing(message.get("name"));
        } else if (message.command.equals("lockthing")) {
            this.askedForLock(message.get("name"));
        } else if (message.command.equals("chat")) {
            int uid = message.get("uid", 0);
            int flags = message.get("flags", 0);
            this.sentChat(uid, flags, message.content);
        } else if (message.command.equals("adduser")) {
            int uid = message.get("uid", 0);
            this.addedUser(uid, message.content);
        } else if (message.command.equals("deleteuser")) {
            int uid = message.get("uid", 0);
            this.deletedUser(uid, message.content);
        } else if (message.command.equals("addroom")) {
            int numClients = message.get("numclients", 0);
            int maxClients = message.get("maxclients", 0);
            this.addedRoom(message.content, numClients, maxClients);
        } else if (message.command.equals("updateroom")) {
            int numClients = message.get("numclients", 0);
            int maxClients = message.get("maxclients", 0);
            this.updatedRoom(message.content, numClients, maxClients);
        } else if (message.command.equals("deleteroom")) {
            this.deletedRoom(message.content);
        } else if (message.command.equals("enterroom")) {
            int level = message.get("level", 0);
            this.enteredRoom(message.content, level);
        } else if (message.command.equals("exitroom")) {
            int level = message.get("level", 0);
            this.exitedRoom(message.content, level);
        } else if (message.command.equals("denyroom")) {
            this.deniedRoom(message.content);
        } else if (message.command.equals("grantlogin")) {
            int uid = message.get("uid", 0);
            this.grantedLogin(uid);
        } else if (message.command.equals("broadcast")) {
            this.sentBroadcast(message.content);
        } else if (message.command.equals("endlist")) {
            this.endedList();
        } else if (message.command.equals("time")) {
            long utcMillis = Long.parseLong(message.content);
            this.gotTime(new Date(utcMillis));
        } else if (message.command.equals("userxy")) {
            int uid = message.get("uid", 0);
            double latitude = message.get("lat", 0.0);
            double longitude = message.get("lon", 0.0);
            this.gotUserLocation(uid, latitude, longitude);
        } else if (message.command.equals("addmeeting")) {
            int minutesUTC = message.get("mutc", 0);
            int numClients = message.get("numclients", 0);
            Date when = new Date((long)minutesUTC * 60000L);
            this.addedMeeting(when, numClients);
        } else if (message.command.equals("denylogin")) {
            this.deniedLogin(message.content);
        } else {
            result = false;
        }
        return result;
    }
}

