/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.drumbox;

import com.transjam.drumbox.DrumSynth;
import com.transjam.drumbox.JSynDrumSynth;
import com.transjam.drumbox.SongDelegate;
import com.transjam.drumbox.SongModel;
import com.transjam.drumbox.SongPlayer;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class DrumBox
extends Panel {
    private String VERSION = "V2.8 (build 123)";
    private SongModel songModel;
    private SongDelegate songDelegate;
    private SongPlayer songPlayer;
    private DrumSynth drumSynth;
    private Frame drumFrame;
    private Button showButton;
    private ScrollPane scrollPane;
    static final int NUM_TRACKS = 8;
    public static Applet applet = null;
    public static final Color COLOR_BACKGROUND = new Color(255, 240, 230);
    public static final Color COLOR_FOREGROUND = new Color(0, 0, 0);
    public static final Color COLOR_GRID = new Color(140, 120, 160);
    public static final Color COLOR_TRACK = new Color(100, 130, 160);
    public static final Color COLOR_CURSOR = new Color(255, 0, 0);
    public static final Color COLOR_OFF = new Color(25, 25, 25);
    public static final Color COLOR_QUIET = new Color(75, 75, 200);
    public static final Color COLOR_NORMAL = new Color(100, 200, 150);
    public static final Color COLOR_LOUD = new Color(255, 220, 75);

    public DrumBox(Applet applet) {
        DrumBox.applet = applet;
        this.setLayout(new BorderLayout());
        this.drumFrame = new Frame("JSyn DrumBox by SoftSynth.com, " + this.VERSION);
        this.drumFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DrumBox.this.drumFrame.hide();
            }
        });
        this.scrollPane = new ScrollPane(0);
        this.drumFrame.add(this.scrollPane);
        this.setSafeSize(this.drumFrame, 800, 800);
        this.drumFrame.setLocation(50, 50);
        Panel drumPanel = new Panel();
        this.scrollPane.add(drumPanel);
        drumPanel.setBackground(COLOR_BACKGROUND);
        drumPanel.setForeground(COLOR_FOREGROUND);
        this.drumSynth = new JSynDrumSynth();
        this.drumSynth.init();
        this.songModel = new SongModel(8);
        this.songPlayer = new SongPlayer(this.songModel, this.drumSynth);
        this.songDelegate = new SongDelegate(this.songModel, this.songPlayer, this.drumSynth);
        drumPanel.add(this.songDelegate);
        this.showButton = new Button("Show WebDrum Window");
        this.add("Center", this.showButton);
        this.showButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrumBox.this.drumFrame.show();
            }
        });
        this.validate();
    }

    void setSafeSize(Component comp, int width, int height) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int screenWidth = screenSize.width;
        int screenHeight = screenSize.height - 50;
        if (width > screenWidth && screenWidth > 300) {
            width = screenWidth;
        }
        if (height > screenHeight && screenHeight > 300) {
            height = screenHeight;
        }
        comp.setSize(width, height);
    }

    public void start() {
        this.songModel.reset();
        this.drumSynth.start();
        this.songPlayer.start();
    }

    @Override
    public void show() {
        this.drumFrame.show();
        this.drumFrame.toFront();
    }

    @Override
    public void hide() {
        this.drumFrame.hide();
    }

    public void stop() {
        this.songPlayer.stop();
        this.drumSynth.stop();
    }

    public void term() {
        this.drumSynth.term();
    }

    public SongModel getSongModel() {
        return this.songModel;
    }

    public SongDelegate getSongDelegate() {
        return this.songDelegate;
    }

    public static InputStream openFileOrURL(String fileName) throws IOException {
        InputStream stream = null;
        try {
            if (applet != null) {
                URL sampleURL = new URL(applet.getCodeBase(), fileName);
                stream = sampleURL.openConnection().getInputStream();
            } else {
                URL webURL = new URL("http://www.transjam.com/webdrum/");
                URL sampleURL = new URL(webURL, fileName);
                stream = sampleURL.openConnection().getInputStream();
            }
        }
        catch (SecurityException e) {
            System.err.println(e);
        }
        return stream;
    }
}

