/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.drumbox;

import com.transjam.drumbox.Tuning;

public class EqualTuning
implements Tuning {
    int[] scale;
    double fundamental = 220.0;
    static final double BASE_MIDI_C = 8.1758224;

    public EqualTuning(double fundamental) {
        this.setFundamental(fundamental);
        this.useMajorScale();
    }

    public EqualTuning() {
        this(EqualTuning.getMIDIFrequency(36.0));
    }

    void useMajorScale() {
        int[] nArray = new int[7];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 9;
        nArray[6] = 11;
        int[] defaultScale = nArray;
        this.setScale(defaultScale);
    }

    void useMinorScale() {
        int[] nArray = new int[7];
        nArray[1] = 2;
        nArray[2] = 3;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 8;
        nArray[6] = 11;
        int[] defaultScale = nArray;
        this.setScale(defaultScale);
    }

    void setScale(int[] pScale) {
        this.scale = pScale;
    }

    @Override
    public void setFundamental(double frequency) {
        this.fundamental = frequency;
    }

    @Override
    public double getFundamental() {
        return this.fundamental;
    }

    @Override
    public int getNotesPerOctave() {
        return this.scale.length;
    }

    public static double getMIDIFrequency(double pitch) {
        return 8.1758224 * Math.pow(2.0, pitch * 0.08333333333333333);
    }

    @Override
    public double pitchToFrequency(int pitch) {
        int index = 0;
        try {
            int notesPerOctave = this.scale.length;
            int octave = pitch / notesPerOctave;
            if (pitch < 0) {
                --octave;
            }
            index = pitch - octave * notesPerOctave;
            int eqPitch = octave * 12 + this.scale[index];
            return this.fundamental * Math.pow(2.0, (double)eqPitch * 0.08333333333333333);
        }
        catch (Exception exc) {
            System.err.println("EqualTuning.pitchToFrequency caught: " + exc);
            System.err.println("EqualTuning.pitchToFrequency: pitch = " + pitch + ", index = " + index);
            return 5000.0;
        }
    }
}

