/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.drumbox;

import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.SynthTable;
import com.softsynth.jsyn.WaveShaper;

public class WaveShapingOscillator
extends SynthNote {
    SineOscillator unitOsc;
    EnvelopePlayer rangeEnv;
    EnvelopePlayer ampEnv;
    SynthEnvelope rangeEnvData;
    SynthEnvelope ampEnvData;
    WaveShaper unitWaveShaper = new WaveShaper();
    SynthInput range;

    public WaveShapingOscillator() {
        this.add(this.unitWaveShaper);
        this.unitOsc = new SineOscillator();
        this.add(this.unitOsc);
        this.rangeEnv = new EnvelopePlayer();
        this.add(this.rangeEnv);
        this.ampEnv = new EnvelopePlayer();
        this.add(this.ampEnv);
        double[] rangeData = new double[]{0.02, 1.0, 0.1, 0.2, 0.1, 0.3, 0.5, 0.1};
        this.rangeEnvData = new SynthEnvelope(rangeData);
        this.rangeEnvData.setSustainLoop(1, 2);
        double[] ampData = new double[]{0.02, 1.0, 0.1, 0.5, 0.5, 0.0};
        this.ampEnvData = new SynthEnvelope(ampData);
        this.ampEnvData.setSustainLoop(1, 1);
        this.frequency = this.unitOsc.frequency;
        this.addPort(this.frequency);
        this.amplitude = this.ampEnv.amplitude;
        this.addPort(this.amplitude);
        this.output = this.unitWaveShaper.output;
        this.addPort(this.output);
        this.range = this.unitOsc.amplitude;
        this.addPort(this.range);
        this.rangeEnv.output.connect(this.range);
        this.ampEnv.output.connect(this.unitWaveShaper.amplitude);
        this.unitOsc.output.connect(this.unitWaveShaper.input);
        this.frequency.setup(0.0, 200.0, 800.0);
        this.amplitude.setup(0.0, 0.5, 1.0);
    }

    public WaveShapingOscillator(SynthTable table) {
        this();
        this.setTable(table);
    }

    public void setTable(SynthTable table) {
        this.unitWaveShaper.tablePort.setTable(table);
    }

    @Override
    public void setStage(int time, int stage) {
        switch (stage) {
            case 0: {
                this.rangeEnv.envelopePort.clear(time);
                this.ampEnv.envelopePort.clear(time);
                this.rangeEnv.envelopePort.queueOn(time, this.rangeEnvData);
                this.ampEnv.envelopePort.queueOn(time, this.ampEnvData);
                this.start(time);
                break;
            }
            case 1: {
                this.rangeEnv.envelopePort.queueOff(time, this.rangeEnvData);
                this.ampEnv.envelopePort.queueOff(time, this.ampEnvData, true);
            }
        }
    }
}

