/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.server;

import com.transjam.admin.AdminProtocolWriter;
import com.transjam.server.ClientTracker;
import com.transjam.server.ScheduleManager;
import com.transjam.server.Thing;
import com.transjam.util.XMLListener;
import com.transjam.util.XMLReader;
import com.transjam.util.XMLWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class Room
implements XMLListener {
    private Hashtable clients;
    private Hashtable rooms;
    private Hashtable things;
    private Room parent;
    private String name;
    private int maxClients = 0;
    private int level;
    private int flags;
    private AdminProtocolWriter writer;
    private ScheduleManager scheduleMgr;
    private XMLReader reader;

    public Room(Room parent, String name, int maxClients, int flags) {
        this.parent = parent;
        this.name = name;
        this.maxClients = maxClients;
        this.flags = flags;
        this.clients = new Hashtable();
        this.rooms = new Hashtable();
        this.things = new Hashtable();
        this.writer = new AdminProtocolWriter();
        this.level = parent != null ? parent.getLevel() + 1 : 0;
    }

    private Room makeNewRoom(String name, int maxClients, int flags) throws IOException {
        Room child = new Room(this, name, maxClients, flags);
        this.addRoom(child);
        return child;
    }

    private void addRoom(Room child) throws IOException {
        this.rooms.put(child.getName(), child);
        String msg = this.writer.addRoom(child.getName(), child.getMaxClients(), child.getNumClients());
        this.sendFormattedMessageToSubscribers(msg, 1);
    }

    private File getRoomFile() {
        return new File("lobby_" + this.getName() + ".xml");
    }

    @Override
    public void beginElement(String tag, Hashtable attributes, boolean ifEmpty) {
        System.out.println("begin tag = " + tag);
        System.out.println("attributes = " + attributes);
        if (tag.equals("schedule")) {
            this.reader.setXMLListener(this.scheduleMgr);
        }
    }

    @Override
    public void foundContent(String content) {
    }

    @Override
    public void endElement(String tag) {
        System.out.println("end tag = " + tag);
        if (tag.equals("schedule")) {
            this.reader.setXMLListener(this);
        }
    }

    private void load() {
        if (this.scheduleMgr != null) {
            try {
                FileInputStream inStream = new FileInputStream(this.getRoomFile());
                this.reader = new XMLReader(inStream);
                this.reader.setXMLListener(this);
                this.reader.parse();
                inStream.close();
            }
            catch (IOException exc) {
                System.err.println("Could not load " + this.getRoomFile());
            }
        }
    }

    private void save() throws IOException {
        if (this.scheduleMgr != null) {
            FileOutputStream outStream = new FileOutputStream(this.getRoomFile());
            XMLWriter writer = new XMLWriter(outStream);
            writer.begin();
            writer.beginElement("lobby");
            writer.writeAttribute("version", 1);
            writer.writeAttribute("name", this.getName());
            writer.beginElement("schedule");
            this.scheduleMgr.save(writer);
            writer.endElement();
            writer.endElement();
            writer.end();
            writer.close();
            outStream.close();
        }
    }

    private void removeRoom(Room child) throws IOException {
        child.save();
        this.rooms.remove(child.getName());
        String msg = this.writer.deleteRoom(child.getName());
        this.sendFormattedMessageToSubscribers(msg, 1);
    }

    private Thing makeNewThing(ClientTracker client, String name) throws IOException {
        Thing thing = new Thing(name);
        this.addThing(client, thing);
        return thing;
    }

    private void addThing(ClientTracker client, Thing thing) throws IOException {
        this.things.put(thing.getName(), thing);
        String msg = this.writer.addThing(thing.getName());
        this.sendFormattedMessageToSubscribers(msg, 4);
        if (!client.isSubscribed(4)) {
            client.write(msg);
        }
    }

    private void modifyThing(ClientTracker client, Thing thing, String contents) throws IOException {
        if (thing.setContents(client, contents)) {
            String msg = this.writer.modifyThing(thing.getName(), thing.getContents());
            this.sendFormattedMessageToSubscribers(msg, 4);
            if (!client.isSubscribed(4)) {
                client.write(msg);
            }
        } else {
            client.denyLock(thing.getName());
        }
    }

    private void removeThing(ClientTracker client, Thing thing) throws IOException {
        this.things.remove(thing.getName());
        String msg = this.writer.deleteThing(thing.getName());
        this.sendFormattedMessageToSubscribers(msg, 4);
        if (!client.isSubscribed(4)) {
            client.write(msg);
        }
    }

    private void lockThing(ClientTracker client, Thing thing) throws IOException {
        if (thing.lock(client)) {
            String msg = this.writer.grantLock(thing.getName(), client.getUserID());
            this.sendFormattedMessageToSubscribers(msg, 4);
            if (!client.isSubscribed(4)) {
                client.write(msg);
            }
        }
    }

    private boolean unlockThing(ClientTracker oldOwner, Thing thing) throws IOException {
        String msg;
        if (!thing.isLockedBy(oldOwner)) {
            return false;
        }
        boolean result = false;
        ClientTracker newOwner = thing.unlock(oldOwner);
        if (newOwner == null) {
            msg = this.writer.unlockThing(thing.getName());
            this.sendFormattedMessageToSubscribers(msg, 4);
            if (!oldOwner.isSubscribed(4)) {
                oldOwner.write(msg);
            }
        } else {
            msg = this.writer.grantLock(thing.getName(), newOwner.getUserID());
            this.sendFormattedMessageToSubscribers(msg, 4);
            if (!newOwner.isSubscribed(4)) {
                newOwner.write(msg);
            }
        }
        ClientTracker nextOwner = thing.processPendingClient();
        return result;
    }

    private void writeOtherClient(ClientTracker other, String message) {
        try {
            other.write(message);
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            ioe.printStackTrace();
        }
    }

    private void sendFormattedMessageToAll(String message) {
        Enumeration e = this.clients.elements();
        while (e.hasMoreElements()) {
            ClientTracker other = (ClientTracker)e.nextElement();
            this.writeOtherClient(other, message);
        }
    }

    private void sendFormattedMessageToOthers(int fromID, String message) {
        Enumeration e = this.clients.elements();
        while (e.hasMoreElements()) {
            ClientTracker other = (ClientTracker)e.nextElement();
            if (other.getUserID() == fromID) continue;
            this.writeOtherClient(other, message);
        }
    }

    private void sendFormattedMessageToSubscribers(String message, int mask) {
        Enumeration e = this.clients.elements();
        while (e.hasMoreElements()) {
            ClientTracker other = (ClientTracker)e.nextElement();
            if (!other.isSubscribed(mask)) continue;
            this.writeOtherClient(other, message);
        }
    }

    public void setMaxClients(int maxClients) {
        this.maxClients = maxClients;
    }

    public int getMaxClients() {
        return this.maxClients;
    }

    public int getNumClients() {
        return this.clients.size();
    }

    public Room getParent() {
        return this.parent;
    }

    public int getLevel() {
        return this.level;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public void modifyThing(ClientTracker client, String name, String contents) throws IOException {
        Thing thing = (Thing)this.things.get(name);
        if (thing == null) {
            client.noThing(name);
        } else {
            this.modifyThing(client, thing, contents);
        }
    }

    public void deleteThing(ClientTracker client, String name) throws IOException {
        Thing thing = (Thing)this.things.get(name);
        if (thing == null) {
            client.noThing(name);
        } else if (thing.isLockedBy(client)) {
            this.removeThing(client, thing);
        } else {
            client.denyLock(thing.getName());
        }
    }

    public void denyLock(ClientTracker client, String name) throws IOException {
        Thing thing = (Thing)this.things.get(name);
        if (thing == null) {
            client.noThing(name);
        } else {
            thing.denyLock();
        }
    }

    public void unlockThing(ClientTracker oldOwner, String name) throws IOException {
        Thing thing = (Thing)this.things.get(name);
        if (thing == null) {
            oldOwner.noThing(name);
        } else {
            this.unlockThing(oldOwner, thing);
        }
    }

    public void lockThing(ClientTracker client, String name) throws IOException {
        Thing thing = (Thing)this.things.get(name);
        if (thing == null) {
            thing = this.makeNewThing(client, name);
        }
        this.lockThing(client, thing);
    }

    public void lockNewThing(ClientTracker client, String name, String contents) throws IOException {
        if (!this.things.containsKey(name)) {
            Thing thing = this.makeNewThing(client, name);
            this.lockThing(client, thing);
            this.modifyThing(client, thing, contents);
        } else {
            client.denyThing(name);
        }
    }

    public void lockOldThing(ClientTracker client, String name) throws IOException {
        Thing thing = (Thing)this.things.get(name);
        if (thing == null) {
            client.noThing(name);
        } else {
            this.lockThing(client, thing);
        }
    }

    public void joinNewRoom(ClientTracker client, String name, int maxClients, int flags) throws IOException {
        if (!this.rooms.containsKey(name)) {
            Room child = this.makeNewRoom(name, maxClients, flags);
            child.addClient(client);
        } else {
            client.denyRoom(name);
        }
    }

    public void joinRoom(ClientTracker client, String name, int maxClients, int flags) throws IOException {
        Room child = (Room)this.rooms.get(name);
        if (child == null) {
            child = this.makeNewRoom(name, maxClients, flags);
        }
        child.addClient(client);
    }

    public void joinOldRoom(ClientTracker client, String name) throws IOException {
        Room child = (Room)this.rooms.get(name);
        if (child == null) {
            client.denyRoom(name);
        } else {
            child.addClient(client);
        }
    }

    private void childRoomChanged(Room child) {
        String msg = this.writer.updateRoom(child.getName(), child.getMaxClients(), child.getNumClients());
        this.sendFormattedMessageToSubscribers(msg, 1);
    }

    private void setEncounters(ClientTracker client) {
        if (this.level >= 2 && this.getNumClients() > 0) {
            Enumeration e;
            client.setEncountered(true);
            if (this.getNumClients() == 1 && (e = this.clients.elements()).hasMoreElements()) {
                ClientTracker other = (ClientTracker)e.nextElement();
                other.setEncountered(true);
            }
        }
    }

    public boolean addClient(ClientTracker client) throws IOException {
        if (this.clients.size() < this.maxClients || this.maxClients <= 0) {
            Room previousRoom = client.getRoom();
            if (previousRoom != null) {
                client.write(this.writer.exitRoom(previousRoom.getLevel(), previousRoom.getName()));
            }
            client.setRoom(this);
            client.debugln(115, "Room:  joined " + this.getName() + ", " + this.getNumClients() + "/" + this.getMaxClients() + ", level " + this.level);
            this.setEncounters(client);
            this.clients.put(new Integer(client.getUserID()), client);
            String msg = this.writer.addUser(client.getName(), client.getUserID());
            this.sendFormattedMessageToSubscribers(msg, 2);
            this.sendUserLocation(client);
            if (this.parent != null) {
                this.parent.childRoomChanged(this);
            }
            client.write(this.writer.enterRoom(this.getLevel(), this.getName()));
            return true;
        }
        client.debugln(115, "Room full. Denied entry to " + this.getName());
        client.write(this.writer.denyRoom(this.getName()));
        return false;
    }

    private void unlockAllClientThings(ClientTracker client) throws IOException {
        int userID = client.getUserID();
        Enumeration e = this.things.elements();
        while (e.hasMoreElements()) {
            Thing thing = (Thing)e.nextElement();
            if (!thing.isLockedBy(client)) continue;
            this.unlockThing(client, thing);
        }
    }

    public void removeClient(ClientTracker client) throws IOException {
        if (client.getName() != null && !client.getName().equals("transjam_checker")) {
            client.debugln(115, "Room:  left " + this.getName() + ", " + this.getNumClients() + "/" + this.getMaxClients());
        }
        try {
            this.unlockAllClientThings(client);
        }
        finally {
            this.clients.remove(new Integer(client.getUserID()));
            client.clearSubscription(-1);
            if (this.parent != null) {
                this.parent.childRoomChanged(this);
            }
            if (this.clients.size() == 0) {
                if (this.rooms.size() == 0 && this.parent != null) {
                    this.parent.removeRoom(this);
                }
            } else {
                String msg = this.writer.deleteUser(client.getName(), client.getUserID());
                this.sendFormattedMessageToSubscribers(msg, 2);
            }
        }
    }

    public void sendRoomList(ClientTracker client) throws IOException {
        client.setSubscription(1);
        Enumeration e = this.rooms.elements();
        while (e.hasMoreElements()) {
            Room child = (Room)e.nextElement();
            client.addRoom(child);
        }
        client.endList();
    }

    public void sendUserList(ClientTracker client) throws IOException {
        client.setSubscription(2);
        Enumeration e = this.clients.elements();
        while (e.hasMoreElements()) {
            ClientTracker other = (ClientTracker)e.nextElement();
            client.addUser(other);
        }
        client.endList();
    }

    public void requestUserLocations(ClientTracker client) throws IOException {
        client.setSubscription(8);
        Enumeration e = this.clients.elements();
        while (e.hasMoreElements()) {
            ClientTracker other = (ClientTracker)e.nextElement();
            if (other.getLocation() == null) continue;
            client.sendLocation(other);
        }
    }

    public synchronized void sendThingList(ClientTracker client) throws IOException {
        client.setSubscription(4);
        Enumeration e = this.things.elements();
        while (e.hasMoreElements()) {
            Thing thing = (Thing)e.nextElement();
            client.addThing(thing);
            if (thing.isLocked()) {
                client.grantLock(thing.getName(), thing.getOwner().getUserID());
            }
            if (thing.getContents() == null) continue;
            client.modifyThing(thing.getName(), thing.getContents());
        }
        client.endList();
    }

    public synchronized void sendAll(ClientTracker fromClient, String message) throws IOException {
        int fromID = fromClient.getUserID();
        String msg = this.writer.sendAll(fromID, message);
        this.sendFormattedMessageToAll(msg);
    }

    public synchronized void sendOthers(ClientTracker fromClient, String message) throws IOException {
        int fromID = fromClient.getUserID();
        String msg = this.writer.sendOthers(fromID, message);
        this.sendFormattedMessageToOthers(fromID, msg);
    }

    public synchronized void sendUser(ClientTracker fromClient, int targetID, String message) throws IOException {
        int fromID = fromClient.getUserID();
        ClientTracker targetClient = (ClientTracker)this.clients.get(new Integer(targetID));
        if (targetClient != null) {
            this.writeOtherClient(targetClient, this.writer.sendUser(fromID, message));
        }
    }

    public synchronized void sendChat(ClientTracker fromClient, int flags, String message) {
        int fromID = fromClient.getUserID();
        String msg = this.writer.sendChat(fromID, flags, message);
        this.sendFormattedMessageToAll(msg);
    }

    public synchronized void broadcast(String text) {
        String msg = this.writer.broadcast(text);
        this.sendFormattedMessageToAll(msg);
        Enumeration e = this.rooms.elements();
        while (e.hasMoreElements()) {
            Room child = (Room)e.nextElement();
            child.broadcast(text);
        }
    }

    private ScheduleManager getSchedule() throws IOException {
        if (this.scheduleMgr == null) {
            if (this.level != 1) {
                throw new IOException("Schedules only supported on lobby level, not level = " + this.level);
            }
            this.scheduleMgr = new ScheduleManager();
            this.load();
        }
        return this.scheduleMgr;
    }

    public synchronized void joinMeeting(ClientTracker fromClient, Date when) throws IOException {
        this.getSchedule().joinMeeting(when);
    }

    public synchronized void requestMeetingList(ClientTracker fromClient) throws IOException {
        this.getSchedule().requestMeetingList(fromClient);
    }

    public void sendUserLocation(ClientTracker client) {
        if (client.getLocation() != null) {
            String msg = this.writer.sendLocation(client.getUserID(), client.getLocation());
            this.sendFormattedMessageToSubscribers(msg, 8);
        }
    }
}

