/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.server;

import com.transjam.iptoxy.IPLocationDaemon;
import com.transjam.iptoxy.IPLocatorMaxMind;
import com.transjam.server.AdminTracker;
import com.transjam.server.ClientAccepter;
import com.transjam.server.ClientMessage;
import com.transjam.server.ClientTracker;
import com.transjam.server.MessageQueue;
import com.transjam.server.Room;
import com.transjam.util.DebugLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class Server {
    private static final int SLOW_SERVER_DELAY = 0;
    public static final int BUILD_INDEX = 128;
    public static final String SERVER_INFO = "TransJam Server build 128";
    public static final int MAX_CLIENTS = 500;
    public static final int CLIENT_SCAN_PERIOD = 60000;
    private static final String DEFAULT_PROPFILENAME = "transjam.properties";
    private Properties properties;
    private String adminPassword = "zxcvbn";
    private int maxClients = 500;
    private int portNum = 17952;
    private int timeoutMSec = 22500;
    private String debugOptions = "uslc";
    private MessageQueue inputQueue = new MessageQueue();
    private ClientAccepter clientListener;
    private ClientAccepter adminListener;
    private Vector clients = new Vector();
    private static IPLocationDaemon locationDaemon;
    private String locatorLicenseKey;
    private URL locatorServiceURL;
    private boolean continueServing = true;
    int acceptedClients = 0;
    int deniedClients = 0;
    int brokenClients = 0;
    int numEncounters = 0;
    double totalSeconds = 0.0;
    Room topRoom;

    public Server(File propFile) throws IOException, SecurityException {
        this.loadProperties(propFile);
        String prop = this.properties.getProperty("portnum");
        if (prop != null) {
            this.portNum = Integer.parseInt(prop);
        }
        if ((prop = this.properties.getProperty("maxclients")) != null) {
            this.maxClients = Integer.parseInt(prop);
        }
        if ((prop = this.properties.getProperty("debug")) != null) {
            this.debugOptions = prop;
        }
        if ((prop = this.properties.getProperty("timeout")) != null) {
            this.timeoutMSec = 1000 * Integer.parseInt(prop);
        }
        if ((prop = this.properties.getProperty("password")) != null) {
            this.adminPassword = prop;
        }
        if ((prop = this.properties.getProperty("locatorLicense")) != null) {
            this.locatorLicenseKey = prop;
        }
        if ((prop = this.properties.getProperty("locatorURL")) != null) {
            this.locatorServiceURL = new URL(prop);
        }
        if (this.locatorLicenseKey != null) {
            IPLocatorMaxMind locator = this.locatorServiceURL == null ? new IPLocatorMaxMind(this.locatorLicenseKey) : new IPLocatorMaxMind(this.locatorServiceURL, this.locatorLicenseKey);
            locationDaemon = new IPLocationDaemon(this, locator);
        }
        System.out.println("Port = " + this.portNum);
        System.out.println("MaxClients = " + this.maxClients);
        if (this.debugOptions != null) {
            System.out.println("DebugOptions = " + this.debugOptions);
        }
        if (this.timeoutMSec > 600000) {
            System.err.println("WARNING: Very long time out = " + this.timeoutMSec + " msec.");
        } else {
            System.out.println("TimeOut = " + this.timeoutMSec + " msec.");
        }
        if (this.locatorLicenseKey != null) {
            System.out.println("locatorLicenseKey = " + this.locatorLicenseKey);
        }
        if (this.locatorServiceURL != null) {
            System.out.println("locatorServiceURL = " + this.locatorServiceURL);
        }
        DebugLog.setOptions(this.debugOptions);
        this.setMaxClients(this.maxClients);
        this.topRoom = new Room(null, "purgatory", 0, 0);
        this.topRoom.setMaxClients(0);
        this.clientListener = new ClientAccepter(this, this.portNum);
        this.adminListener = new AdminListener(this, this.portNum + 1);
    }

    private void loadProperties(File pPropFile) {
        block2: {
            File propFile = pPropFile != null ? pPropFile : new File(DEFAULT_PROPFILENAME);
            this.properties = new Properties();
            try {
                FileInputStream inStream = new FileInputStream(propFile);
                this.properties.load(inStream);
                inStream.close();
            }
            catch (IOException exc) {
                System.err.println("Warning: could not load TransJam properties from " + propFile.getAbsolutePath());
                System.err.println("         " + exc);
                if (pPropFile == null) break block2;
                throw new RuntimeException("Properties file specified but could not be loaded.");
            }
        }
    }

    private void setMaxClients(int max) {
        if (max > 500) {
            System.err.println("maxClients cannot exceed 500");
            max = 500;
        }
        this.maxClients = max;
    }

    public int getMaxClients() {
        return this.maxClients;
    }

    public int getTimeoutMSec() {
        return this.timeoutMSec;
    }

    public void broadcast(String text) {
        this.topRoom.broadcast(text);
    }

    public void postMessage(ClientMessage cmsg) {
        this.inputQueue.send(cmsg);
    }

    public void kill() {
        this.continueServing = false;
    }

    private void scanForDeadClients(long lastClientScanTime) {
        Enumeration enumer = this.clients.elements();
        while (enumer.hasMoreElements()) {
            ClientTracker client = (ClientTracker)enumer.nextElement();
            if (client.hasReceivedMessageSince(lastClientScanTime)) continue;
            DebugLog.debugln("BUG in server. Found dead client in scan!");
            client.stop();
            client.cleanup();
        }
    }

    private void processClientMessage(ClientMessage cmsg) {
        ClientTracker clientTracker = cmsg.clientTracker;
        if (clientTracker.isActive()) {
            switch (cmsg.type) {
                case 0: {
                    try {
                        clientTracker.sendInfo(3, SERVER_INFO);
                        this.topRoom.addClient(clientTracker);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        clientTracker.stop();
                    }
                    break;
                }
                case 1: {
                    try {
                        clientTracker.processMessage(cmsg.message);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        clientTracker.stop();
                    }
                    break;
                }
                case 3: {
                    clientTracker.debugln(104, "Server received TIMEOUT from " + clientTracker.getName());
                    try {
                        clientTracker.requestEcho("clientCheck");
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        clientTracker.stop();
                    }
                    break;
                }
                case 2: {
                    DebugLog.debugln("Client Throwable = " + cmsg.throwable);
                    break;
                }
                case 4: {
                    clientTracker.cleanup();
                }
            }
        }
    }

    private void serve() {
        long lastClientScanTime = System.currentTimeMillis();
        if (locationDaemon != null) {
            locationDaemon.start();
        }
        this.clientListener.start();
        this.adminListener.start();
        while (this.continueServing) {
            try {
                long currentTime;
                ClientMessage cmsg = (ClientMessage)this.inputQueue.waitForMessage(60000);
                if (cmsg != null) {
                    this.processClientMessage(cmsg);
                }
                if ((currentTime = System.currentTimeMillis()) - lastClientScanTime <= 60000L) continue;
                this.scanForDeadClients(lastClientScanTime);
                lastClientScanTime = currentTime;
            }
            catch (InterruptedException exc) {
                this.continueServing = false;
            }
        }
        this.clientListener.close();
        this.adminListener.close();
        if (locationDaemon != null) {
            locationDaemon.stop();
        }
    }

    public synchronized String requestAdminLogin(AdminTracker admin, String pPassword) {
        if (pPassword.equals(this.adminPassword)) {
            return null;
        }
        admin.debugln(117, "Rejected admin request for " + pPassword);
        return "Invalid password.";
    }

    public static void debug(ClientTracker client, int code, String msg) {
        DebugLog.debugln(code, String.valueOf(client.getUserID()) + ", " + client.getName() + ": " + msg);
    }

    public String requestClientLogin(ClientTracker client) {
        if (this.getNumClients() < this.maxClients) {
            this.clients.addElement(client);
            if (client.getName() != null && !client.getName().equals("transjam_checker")) {
                ++this.acceptedClients;
                client.debugln(117, "Login: " + client.getSocket().getInetAddress() + ", on " + new Date());
            }
            return null;
        }
        client.debugln(117, "Server full. Rejected login request.");
        ++this.deniedClients;
        return "Too many people are logged in!";
    }

    public synchronized void logoutClient(ClientTracker client) {
        this.clients.remove(client);
        if (client.isBroken()) {
            ++this.brokenClients;
        }
        if (client.getName() == null || !client.getName().equals("transjam_checker")) {
            Date outDate = new Date();
            long elapsedMsec = outDate.getTime() - client.getLoginTime();
            double seconds = (double)elapsedMsec / 1000.0;
            double minutes = seconds / 60.0;
            minutes = (double)((int)(minutes * 100.001)) / 100.0;
            if (!(client instanceof AdminTracker)) {
                if (client.getEncountered()) {
                    ++this.numEncounters;
                }
                this.totalSeconds += seconds;
            }
            client.debugln(117, "Logged out on " + outDate + " after " + minutes + " minutes" + ", encountered = " + client.getEncountered() + ", broken = " + client.isBroken());
        }
    }

    public static void main(String[] argv) {
        block7: {
            System.out.println("TransJam Server, build 128, (C) 2001-4 SoftSynth.com");
            File propFile = null;
            int i = 0;
            while (i < argv.length) {
                String s = argv[i];
                System.out.println("s = " + s);
                if (s.startsWith("-p")) {
                    propFile = new File(s.substring(2, s.length()));
                }
                ++i;
            }
            Server master = null;
            try {
                try {
                    master = new Server(propFile);
                    master.serve();
                }
                catch (Throwable thr) {
                    System.err.println("Server caught " + thr);
                    thr.printStackTrace();
                    System.out.println("TransJam Server exiting. Build 128");
                    break block7;
                }
            }
            catch (Throwable throwable) {
                System.out.println("TransJam Server exiting. Build 128");
                throw throwable;
            }
            System.out.println("TransJam Server exiting. Build 128");
        }
        System.exit(0);
    }

    public int getNumClients() {
        return this.clients.size();
    }

    public static void requestLocation(ClientTracker client) {
        if (locationDaemon != null) {
            locationDaemon.requestLocation(client);
        }
    }

    class AdminListener
    extends ClientAccepter {
        public AdminListener(Server server2, int portNum) throws IOException, SecurityException {
            super(server2, portNum);
        }

        @Override
        public ClientTracker makeClient(Socket socket) throws IOException {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return new AdminTracker(this.server, this.getNextID(), socket);
        }
    }
}

