/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.util;

import com.transjam.util.ClientMonitorListener;
import com.transjam.util.ProtocolReader;
import com.transjam.util.TransjamMessage;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;

public class ClientMonitor
extends ProtocolReader
implements Runnable {
    private ClientMonitorListener listener;
    private Socket socket;
    private Thread thread;
    private volatile boolean go = true;

    public ClientMonitor(ClientMonitorListener pClientMonitorListener) {
        this.listener = pClientMonitorListener;
    }

    public void setSocket(Socket pSocket, int timeoutMSec) throws IOException {
        this.socket = pSocket;
        InputStream inStr = this.socket.getInputStream();
        if (timeoutMSec > 0) {
            this.socket.setSoTimeout(timeoutMSec);
            TimeoutFilterInputStream timedInStr = new TimeoutFilterInputStream(inStr);
            this.setStream(timedInStr);
        } else {
            this.setStream(inStr);
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.go = false;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.listener.gotStart();
        try {
            try {
                this.parse();
            }
            catch (SocketException e) {
                System.out.println("ClientMonitor: " + e.getMessage());
                this.listener.gotStop();
                this.stop();
            }
            catch (Throwable thr) {
                this.listener.gotThrowable(thr);
                this.listener.gotStop();
                this.stop();
            }
        }
        finally {
            this.listener.gotStop();
            this.stop();
        }
    }

    @Override
    public void gotMessage(TransjamMessage msg) throws IOException {
        this.listener.gotMessage(msg);
    }

    class TimeoutFilterInputStream
    extends FilterInputStream {
        public TimeoutFilterInputStream(InputStream str) {
            super(str);
        }

        @Override
        public int read() throws IOException {
            int result = -1;
            int numTimeouts = 0;
            while (ClientMonitor.this.go) {
                if (ClientMonitor.this.socket == null) {
                    throw new IOException("No socket available to read.");
                }
                try {
                    result = super.read();
                    break;
                }
                catch (InterruptedIOException iioe) {
                    ClientMonitor.this.listener.gotTimeout(++numTimeouts);
                }
            }
            return result;
        }
    }
}

