/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.util;

import com.transjam.util.ClientLocation;
import com.transjam.util.XMLTools;
import java.io.IOException;
import java.util.Date;

public class ProtocolWriter {
    StringBuffer buffer;

    public void beginMessage(String command) {
        this.buffer = new StringBuffer();
        this.buffer.append("<").append(command);
    }

    public void writeAttribute(String name, String value) {
        this.buffer.append(" ").append(name).append("=\"").append(value).append("\"");
    }

    public void writeAttribute(String name, int value) {
        this.writeAttribute(name, Integer.toString(value));
    }

    public void writeAttribute(String name, double value) {
        this.writeAttribute(name, Double.toString(value));
    }

    public String finishMessage() {
        this.buffer.append(" />");
        return this.buffer.toString();
    }

    public String finishMessage(String command) {
        return this.finishMessage(command, null);
    }

    public String finishMessage(String command, String content) {
        if (content == null) {
            this.buffer.append(" />");
        } else {
            String escapedContent = XMLTools.escapeText(content);
            this.buffer.append(">").append(escapedContent);
            this.buffer.append("</").append(command).append(">");
        }
        return this.buffer.toString();
    }

    public synchronized String makeMessage(String command) {
        this.beginMessage(command);
        return this.finishMessage();
    }

    public synchronized String makeMessage(String command, String content) {
        this.beginMessage(command);
        return this.finishMessage(command, content);
    }

    public synchronized String makeMessage(String command, String name, String value) {
        this.beginMessage(command);
        this.writeAttribute(name, value);
        return this.finishMessage();
    }

    public synchronized String makeMessage(String command, String name, int value) {
        this.beginMessage(command);
        this.writeAttribute(name, value);
        return this.finishMessage();
    }

    public synchronized String makeMessage(String command, String name, String value, String content) {
        this.beginMessage(command);
        this.writeAttribute(name, value);
        return this.finishMessage(command, content);
    }

    public synchronized String makeMessage(String command, String name, int value, String content) {
        this.beginMessage(command);
        this.writeAttribute(name, value);
        return this.finishMessage(command, content);
    }

    public String sendEcho(String content) {
        return this.makeMessage("echo", content);
    }

    public String requestTime() {
        return this.makeMessage("reqtime");
    }

    public String sendTime(long currentMillis) {
        return this.makeMessage("time", "" + currentMillis);
    }

    public String requestEcho(String content) {
        return this.makeMessage("reqecho", content);
    }

    public String sendSync(String content) {
        return this.makeMessage("sync", content);
    }

    public String deleteThing(String name) {
        return this.makeMessage("deletething", "name", name);
    }

    public String denyThing(String name) {
        return this.makeMessage("denything", "name", name);
    }

    public String modifyThing(String name, String contents) {
        return this.makeMessage("modifything", "name", name, contents);
    }

    public String denyRoom(String name) {
        return this.makeMessage("denyroom", name);
    }

    public synchronized String addRoom(String name, int maxClients, int numClients) {
        this.beginMessage("addroom");
        this.writeAttribute("maxclients", maxClients);
        this.writeAttribute("numclients", numClients);
        return this.finishMessage("addroom", name);
    }

    public synchronized String updateRoom(String name, int maxClients, int numClients) {
        this.beginMessage("updateroom");
        this.writeAttribute("maxclients", maxClients);
        this.writeAttribute("numclients", numClients);
        return this.finishMessage("updateroom", name);
    }

    public String deleteRoom(String name) {
        return this.makeMessage("deleteroom", name);
    }

    public String endList() {
        return this.makeMessage("endlist");
    }

    public String addUser(String name, int userID) {
        return this.makeMessage("adduser", "uid", userID, name);
    }

    public String deleteUser(String name, int userID) {
        return this.makeMessage("deleteuser", "uid", userID, name);
    }

    public String grantLogin(int userID) {
        return this.makeMessage("grantlogin", "uid", userID);
    }

    public String denyLogin(String reason) {
        return this.makeMessage("denylogin", reason);
    }

    public synchronized String sendChat(int userID, int flags, String msg) {
        this.beginMessage("chat");
        this.writeAttribute("uid", userID);
        if (flags != 0) {
            this.writeAttribute("flags", flags);
        }
        return this.finishMessage("chat", msg);
    }

    public String sendAll(int userID, String msg) {
        return this.makeMessage("sendall", "uid", userID, msg);
    }

    public String sendOthers(int userID, String msg) {
        return this.makeMessage("sendothers", "uid", userID, msg);
    }

    public String sendUser(int userID, String msg) {
        return this.makeMessage("senduser", "uid", userID, msg);
    }

    public String requestMeetingList() {
        return this.makeMessage("reqschedule");
    }

    public String joinMeeting(Date when) {
        int minutesUTC = (int)(when.getTime() / 60000L);
        return this.makeMessage("joinmeeting", "mutc", minutesUTC);
    }

    public synchronized String addMeeting(Date when, int numClients) {
        this.beginMessage("addmeeting");
        int minutesUTC = (int)(when.getTime() / 60000L);
        this.writeAttribute("mutc", minutesUTC);
        this.writeAttribute("numclients", numClients);
        return this.finishMessage("addmeeting");
    }

    public String lockNewThing(String name, String contents) {
        return this.makeMessage("locknewthing", "name", name, contents);
    }

    public String lockThing(String name) {
        return this.makeMessage("lockthing", "name", name);
    }

    public synchronized String lockThing(String name, int uid) {
        this.beginMessage("lockthing");
        this.writeAttribute("name", name);
        this.writeAttribute("uid", uid);
        return this.finishMessage("lockthing", name);
    }

    public String lockOldThing(String name) {
        return this.makeMessage("lockoldthing", "name", name);
    }

    public String unlockThing(String name) {
        return this.makeMessage("unlockthing", "name", name);
    }

    public String addThing(String name) {
        return this.makeMessage("addthing", "name", name);
    }

    public String noThing(String name) {
        return this.makeMessage("nothing", "name", name);
    }

    public synchronized String grantLock(String name, int uid) {
        this.beginMessage("grantlock");
        this.writeAttribute("name", name);
        this.writeAttribute("uid", uid);
        return this.finishMessage();
    }

    public synchronized String grantLock(String name) {
        this.beginMessage("grantlock");
        this.writeAttribute("name", name);
        return this.finishMessage();
    }

    public String denyLock(String name) {
        return this.makeMessage("denylock", "name", name);
    }

    public String requestLogin(String userName) {
        return this.makeMessage("requestlogin", userName);
    }

    public String requestLogout() {
        return this.makeMessage("logout");
    }

    public String requestRoomList() {
        return this.makeMessage("listrooms");
    }

    public String requestUserList() {
        return this.makeMessage("listusers");
    }

    public String requestUserLocations() {
        return this.makeMessage("requserxy");
    }

    public String requestThingList() {
        return this.makeMessage("listthings");
    }

    public synchronized String joinNewRoom(String name, int currentLevel, int maxClients, int flags) {
        this.beginMessage("joinnewroom");
        this.writeAttribute("level", currentLevel);
        this.writeAttribute("maxclients", maxClients);
        this.writeAttribute("flags", flags);
        return this.finishMessage("joinnewroom", name);
    }

    public String joinNewRoom(String name) {
        return this.makeMessage("joinnewroom", name);
    }

    public synchronized String joinRoom(String name, int currentLevel, int maxClients, int flags) {
        this.beginMessage("joinroom");
        this.writeAttribute("level", currentLevel);
        this.writeAttribute("maxclients", maxClients);
        this.writeAttribute("flags", flags);
        return this.finishMessage("joinroom", name);
    }

    public String joinRoom(String name) {
        return this.makeMessage("joinroom", name);
    }

    public synchronized String joinOldRoom(String name, int currentLevel) {
        this.beginMessage("joinoldroom");
        this.writeAttribute("level", currentLevel);
        return this.finishMessage("joinoldroom", name);
    }

    public String joinOldRoom(String name) {
        return this.makeMessage("joinoldroom", name);
    }

    public synchronized String leaveRoom(int currentLevel) {
        this.beginMessage("leaveroom");
        this.writeAttribute("level", currentLevel);
        return this.finishMessage("leaveroom");
    }

    public String enterRoom(int level, String name) {
        return this.makeMessage("enterroom", "level", level, name);
    }

    public String exitRoom(int level, String name) {
        return this.makeMessage("exitroom", "level", level, name);
    }

    public String sendAll(String msg) {
        return this.makeMessage("sendall", msg);
    }

    public String sendSelf(String msg) {
        return this.makeMessage("sendself", msg);
    }

    public String sendChat(String msg, int flags) {
        if (flags == 0) {
            return this.makeMessage("chat", msg);
        }
        return this.makeMessage("chat", "flags", flags, msg);
    }

    public String requestValidation() throws IOException {
        return this.makeMessage("validate", "TransJam - Copyright 2001 Phil Burk");
    }

    public String sendInfo(int version, String info) throws IOException {
        return this.makeMessage("info", "version", version, info);
    }

    public String sendLocation(int uid, ClientLocation location) {
        this.beginMessage("userxy");
        this.writeAttribute("uid", uid);
        this.writeAttribute("lat", location.latitude);
        this.writeAttribute("lon", location.longitude);
        return this.finishMessage("leaveroom");
    }
}

