/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import compmus.Melody;
import compmus.MelodyCanvas;
import compmus.MelodyPlayer;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

public class AddNoiseToSong
extends Applet {
    private static final long serialVersionUID = 1L;
    LineOut myOut;
    MelodyPlayer player;
    Vector<Melody> melodies;
    Vector<MelodyCanvas> canvases;
    static final int MAX_BEATS = 16;
    static final int MAX_SONGS = 20;
    int[] gamut;
    Button resetButton;
    Button copyButton;
    Panel canvasPanel;

    public AddNoiseToSong() {
        int[] nArray = new int[7];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 9;
        nArray[6] = 11;
        this.gamut = nArray;
    }

    public static void main(String[] args) {
        AddNoiseToSong applet = new AddNoiseToSong();
        AppletFrame frame = new AppletFrame("Add Noise To Song", applet);
        frame.setSize(600, 350);
        frame.setVisible(true);
        frame.test();
    }

    @Override
    public void start() {
        System.out.println("AddNoiseToSong: build 011");
        this.melodies = new Vector();
        this.canvases = new Vector();
        try {
            Synth.startEngine(0);
            this.player = new MelodyPlayer();
            this.myOut = new LineOut();
            this.player.getOutput().connect(0, this.myOut.input, 0);
            this.player.getOutput().connect(0, this.myOut.input, 1);
            this.myOut.start();
            this.setLayout(new BorderLayout());
            this.canvasPanel = new Panel();
            this.add("Center", this.canvasPanel);
            Panel buttons = new Panel();
            buttons.setLayout(new GridLayout(1, 0));
            this.resetButton = new Button("Reset");
            buttons.add(this.resetButton);
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddNoiseToSong.this.reset();
                }
            });
            this.copyButton = new Button("Make Noisy Copy");
            buttons.add(this.copyButton);
            this.copyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddNoiseToSong.this.makeNoisyCopy();
                }
            });
            this.add("North", buttons);
            this.generateSong();
            this.getParent().validate();
            this.getToolkit().sync();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.player.stop();
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            System.out.println("Caught " + e);
        }
        this.melodies = null;
        this.canvases = null;
    }

    int choose(int numPossibilities) {
        return (int)(Math.random() * (double)numPossibilities);
    }

    int chooseRamped(int numPossibilities) {
        return (int)(Math.random() * Math.random() * (double)numPossibilities);
    }

    void generateSong() {
        int[] scaledIndices = new int[16];
        int[] pitches = new int[16];
        int[] durations = new int[16];
        int n = 0;
        int totalBeats = 0;
        while (totalBeats < 16) {
            int index;
            int beats;
            int beatsLeftInMeasure = 4 - (totalBeats & 3);
            durations[n] = beats = this.chooseRamped(beatsLeftInMeasure - 1) + 1;
            totalBeats += beats;
            if (n == 0) {
                index = 8;
            } else {
                int back = this.chooseRamped(n > 4 ? 4 : n) + 1;
                int delta = this.chooseRamped(5) * (this.choose(2) == 0 ? -1 : 1);
                index = scaledIndices[n - back] + delta;
            }
            if (index < 0) {
                index += this.gamut.length;
            }
            scaledIndices[n] = index;
            pitches[n] = this.gamut[index % this.gamut.length] + 12 * (index / this.gamut.length);
            ++n;
        }
        Melody melody = new Melody(n, pitches, durations);
        this.addMelody(melody);
    }

    void makeNoisyCopy() {
        Melody previous = this.melodies.lastElement();
        int[] pitches = new int[previous.size()];
        int[] durations = new int[previous.size()];
        int i = 0;
        while (i < pitches.length) {
            int pitch = previous.getPitch(i);
            if (this.choose(4) == 0) {
                pitch += this.chooseRamped(5) * (this.choose(2) == 0 ? -1 : 1);
            }
            pitches[i] = pitch;
            int dur = previous.getDuration(i);
            if (this.choose(10) == 0) {
                if ((dur += this.chooseRamped(3) * (this.choose(2) == 0 ? -1 : 1)) <= 0) {
                    dur = 1;
                } else if (dur > 4) {
                    dur = 4;
                }
            }
            durations[i] = dur;
            ++i;
        }
        Melody current = new Melody(previous.size(), pitches, durations);
        this.addMelody(current);
    }

    void addMelody(Melody melody) {
        MelodyCanvas mc = new MelodyCanvas(this.melodies.size(), melody);
        mc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AddNoiseToSong.this.selectMelody((MelodyCanvas)e.getSource());
            }
        });
        this.melodies.addElement(melody);
        this.canvases.addElement(mc);
        if (this.canvases.size() >= 20) {
            this.copyButton.setEnabled(false);
        }
        this.canvasPanel.add(mc);
        this.canvasPanel.invalidate();
        this.getParent().validate();
        this.repaint();
    }

    void reset() {
        this.canvases.setSize(0);
        this.melodies.setSize(0);
        this.canvasPanel.removeAll();
        this.generateSong();
        this.copyButton.setEnabled(true);
    }

    void selectMelody(MelodyCanvas mc) {
        Enumeration<MelodyCanvas> enumer = this.canvases.elements();
        while (enumer.hasMoreElements()) {
            MelodyCanvas mcx;
            mcx.setBackground((mcx = enumer.nextElement()) == mc ? Color.yellow : Color.white);
            mcx.repaint();
        }
        this.player.stop();
        this.player.setMelody(mc.getMelody());
        this.player.start();
    }
}

