/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.Filter_BandPass;
import com.softsynth.jsyn.LineIn;
import com.softsynth.jsyn.PeakFollower;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class ColorOrgan
extends Applet
implements Runnable {
    private OrganCanvas organCanvas;
    private LineIn lineIn;
    private static final int NUM_BANDS = 6;
    private static final double START_FREQ = 80.0;
    private static final double BAND_SCALAR = 2.5;
    private static final double DEFAULT_Q = 3.0;
    private BandAnalyser[] bandAnalysers;
    private static final long DURATION = 50L;
    volatile boolean go;

    public static void main(String[] args) {
        ColorOrgan applet = new ColorOrgan();
        AppletFrame frame = new AppletFrame("Color Organ", applet);
        frame.setSize(400, 300);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        this.organCanvas = new OrganCanvas();
        this.organCanvas.setBackground(Color.black);
        this.add("Center", this.organCanvas);
        try {
            Synth.startEngine(32);
            this.lineIn = new LineIn();
            this.lineIn.start();
            this.bandAnalysers = new BandAnalyser[6];
            double freq = 80.0;
            int i = 0;
            while (i < 6) {
                this.bandAnalysers[i] = new BandAnalyser(freq, 3.0);
                freq *= 2.5;
                this.lineIn.output.connect(0, this.bandAnalysers[i].input, 0);
                this.bandAnalysers[i].start();
                ++i;
            }
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.go = true;
        new Thread(this).start();
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        this.go = false;
        try {
            this.removeAll();
            Synth.setTrace(0);
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    private void updateBands() {
        int i = 0;
        while (i < 6) {
            double level = this.bandAnalysers[i].output.get();
            this.organCanvas.setBandLevel(i, level);
            ++i;
        }
    }

    @Override
    public void run() {
        while (this.go) {
            this.organCanvas.repaint();
            this.updateBands();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    class BandAnalyser
    extends SynthCircuit {
        SynthInput input;
        Filter_BandPass filter = new Filter_BandPass();
        PeakFollower peak;

        public BandAnalyser(double freq, double Q) {
            this.add(this.filter);
            this.filter.frequency.set(freq);
            this.filter.Q.set(Q);
            this.peak = new PeakFollower();
            this.add(this.peak);
            this.filter.output.connect(this.peak.input);
            this.input = this.filter.input;
            this.addPort(this.input);
            this.output = this.peak.output;
            this.addPort(this.output);
        }
    }

    class DarkFilter
    extends RGBImageFilter {
        final int delta = 2;
        final int redDelta = 131072;
        final int greenDelta = 512;
        final int blueDelta = 2;
        protected boolean canFilterIndexColorModel = true;

        DarkFilter() {
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int blue;
            int green;
            int alpha = rgb & 0xFF000000;
            int red = rgb & 0xFF0000;
            if (red >= 131072) {
                red -= 131072;
            }
            if ((green = rgb & 0xFF00) >= 512) {
                green -= 512;
            }
            if ((blue = rgb & 0xFF) >= 2) {
                blue -= 2;
            }
            return alpha | red | green | blue;
        }
    }

    class OrganCanvas
    extends Canvas {
        double[] bands = new double[6];
        Color[] colors = new Color[]{new Color(255, 130, 10), new Color(220, 240, 60), new Color(180, 255, 110), new Color(130, 200, 170), new Color(90, 130, 200), new Color(170, 70, 255)};
        PosVel xPos;
        PosVel yPos;
        int radius = 50;
        double angle = 0.0;
        double angleVelocity = 0.0;
        final double CIRCLE_ANGLE = Math.PI * 2;
        final double MAX_SPIN = 0.3141592653589793;
        boolean useDarkener = true;
        Image image;
        int imageWidth = 0;
        int imageHeight = 0;
        DarkFilter darkener;
        int frameIndex;

        public OrganCanvas() {
            this.darkener = new DarkFilter();
            this.frameIndex = 0;
            this.xPos = new PosVel();
            this.yPos = new PosVel();
        }

        public void setBandLevel(int i, double level) {
            this.bands[i] = level;
        }

        void moveStar() {
            this.xPos.move((double)this.bounds().width - 2.0 * (double)this.radius);
            this.yPos.move((double)this.bounds().height - 2.0 * (double)this.radius);
        }

        void spinStar() {
            this.angle += this.angleVelocity;
            if (this.angle < 0.0) {
                this.angle += Math.PI * 2;
            } else if (this.angle > Math.PI * 2) {
                this.angle -= Math.PI * 2;
            }
            this.angleVelocity += (Math.random() - 0.5) * 0.1 * 0.3141592653589793;
            if (this.angleVelocity < -0.3141592653589793) {
                this.angleVelocity = -0.3141592653589793;
            } else if (this.angleVelocity > 0.3141592653589793) {
                this.angleVelocity = 0.3141592653589793;
            }
        }

        void drawStar(Graphics g) {
            double bandAngle = 1.0471975511965976;
            int i = 0;
            while (i < 6) {
                double band = 0.02 + this.bands[i];
                double a = this.angle + (double)i * bandAngle;
                int x1 = (int)this.xPos.position + this.radius;
                int y1 = (int)this.yPos.position + this.radius;
                int x2 = (int)((double)x1 + band * (double)this.radius * Math.sin(a));
                int y2 = (int)((double)y1 + band * (double)this.radius * Math.cos(a));
                g.setColor(this.colors[i]);
                g.drawLine(x1, y1, x2, y2);
                int ovalSize = (int)(band * 10.0);
                if (ovalSize > 2) {
                    int ovalRadius = ovalSize >> 1;
                    g.fillOval(x2 - ovalRadius, y2 - ovalRadius, ovalSize, ovalSize);
                }
                ++i;
            }
        }

        @Override
        public void update(Graphics g) {
            g.setColor(this.getForeground());
            this.paint(g);
        }

        private void updateImage() {
            Rectangle d = this.bounds();
            if (this.image == null || d.width != this.imageWidth || d.height != this.imageHeight) {
                this.image = this.createImage(d.width, d.height);
                this.imageWidth = d.width;
                this.imageHeight = d.height;
            }
        }

        @Override
        public void paint(Graphics g) {
            this.moveStar();
            this.spinStar();
            this.updateImage();
            Graphics gimg = this.image.getGraphics();
            if (this.useDarkener && (this.frameIndex & 3) == 0) {
                Image darkImage = this.createImage(new FilteredImageSource(this.image.getSource(), this.darkener));
                gimg.drawImage(darkImage, 0, 0, this);
            }
            this.drawStar(gimg);
            g.drawImage(this.image, 0, 0, this);
            ++this.frameIndex;
        }
    }

    class PosVel {
        double position = 0.0;
        double velocity = 3.0;
        double maxVelocity = 4.0;

        PosVel() {
        }

        void move(double limit) {
            this.position += this.velocity;
            if (this.position <= 0.0) {
                this.position = -this.position;
                this.velocity = -this.velocity;
            } else if (this.position >= limit) {
                this.position = limit - (this.position - limit);
                this.velocity = -this.velocity;
            }
            this.velocity += (Math.random() - 0.5) * 0.1 * this.maxVelocity;
            if (this.velocity < -this.maxVelocity) {
                this.velocity = -this.maxVelocity;
            } else if (this.velocity > this.maxVelocity) {
                this.velocity = this.maxVelocity;
            }
        }
    }
}

