/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.view102.LabelledFader;
import com.softsynth.jsyn.view102.Tweakable;
import com.softsynth.jsyn.view102.XYController;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.util.Vector;

public class FletcherMunson
extends Applet
implements Tweakable {
    SineOscillator referenceOsc;
    SineOscillator testOsc;
    LineOut lineOut;
    LabelledFader decibelFader;
    Vector ampFreqVector;
    double referenceAmp;
    double referenceDecibels;
    double testFreq;
    static final double minDB = -40.0;
    static final double startFreq = 50.0;
    static final double endFreq = 22050.0;
    static final double referenceFreq = 3000.0;
    DFDisplay xyplot;
    Button buttonNext;
    Button buttonReset;
    Label labelFreq;
    private static final double a2dScalar = 20.0 / Math.log(10.0);

    public static void main(String[] args) {
        FletcherMunson applet = new FletcherMunson();
        AppletFrame frame = new AppletFrame("Fletcher-Munson Curve", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.ampFreqVector = new Vector();
        try {
            Synth.startEngine(0);
            this.referenceOsc = new SineOscillator();
            this.testOsc = new SineOscillator();
            this.lineOut = new LineOut();
            this.testOsc.output.connect(0, this.lineOut.input, 0);
            this.referenceOsc.output.connect(0, this.lineOut.input, 1);
            this.referenceAmp = this.decibelsToAmplitude(-40.0);
            this.referenceDecibels = -40.0;
            this.setLayout(new BorderLayout());
            this.xyplot = new DFDisplay();
            this.add("Center", this.xyplot);
            Panel controlPanel = new Panel();
            this.add("South", controlPanel);
            controlPanel.setLayout(new GridLayout(0, 1));
            this.decibelFader = new LabelledFader(this, 1, "Decibels (DB)", -40.0, -40.0, 0.0);
            controlPanel.add(this.decibelFader);
            Panel buttonPanel = new Panel();
            controlPanel.add(buttonPanel);
            this.buttonReset = new Button("Reset");
            buttonPanel.add(this.buttonReset);
            this.buttonNext = new Button("Next Frequency");
            buttonPanel.add(this.buttonNext);
            this.labelFreq = new Label("Frequency = 00000.000");
            buttonPanel.add(this.labelFreq);
            this.resetFreq();
            this.referenceOsc.frequency.set(3000.0);
            this.testOsc.amplitude.set(0.5);
            this.referenceOsc.amplitude.set(this.referenceAmp * 0.5);
            this.referenceOsc.start();
            this.testOsc.start();
            this.lineOut.start();
            this.getParent().validate();
            this.getToolkit().sync();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    void resetFreq() {
        this.testFreq = 50.0;
        this.setFreq(this.testFreq);
        this.ampFreqVector.removeAllElements();
    }

    void captureDataPoint() {
        double logFreq = Math.log(this.testFreq);
        this.ampFreqVector.addElement(new DFPair(this.referenceDecibels, logFreq));
        this.xyplot.repaint();
        this.getParent().validate();
        this.getToolkit().sync();
    }

    boolean nextFreq() {
        if (this.testFreq > 22050.0) {
            return true;
        }
        this.captureDataPoint();
        this.testFreq *= 1.3333333333333333;
        if (this.testFreq > 22050.0) {
            return true;
        }
        this.setFreq(this.testFreq);
        return false;
    }

    void setFreq(double freq) {
        this.testOsc.frequency.set(freq);
        this.labelFreq.setText("Frequency = " + freq);
    }

    @Override
    public boolean action(Event evt, Object what) {
        if (evt.target == this.buttonReset) {
            this.resetFreq();
            return true;
        }
        if (evt.target == this.buttonNext) {
            this.nextFreq();
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
        try {
            this.referenceOsc.delete();
            this.testOsc.delete();
            this.lineOut.delete();
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            System.out.println("Caught " + e);
        }
    }

    double amplitudeToDecibels(double amplitude) {
        double db = Math.log(amplitude) * a2dScalar;
        return db;
    }

    double decibelsToAmplitude(double decibels) {
        double amp = Math.pow(10.0, decibels / 20.0);
        return amp;
    }

    @Override
    public void tweak(int targetIndex, double val) {
        switch (targetIndex) {
            case 1: {
                this.referenceDecibels = val;
                this.referenceAmp = this.decibelsToAmplitude(val);
                this.referenceOsc.amplitude.set(this.referenceAmp * 0.5);
            }
        }
    }

    class DFDisplay
    extends XYController {
        int radius;

        public DFDisplay() {
            super(Math.log(25.0), -43.0, Math.log(22050.0), 3.0);
            this.radius = 8;
            this.setMinWorldX(Math.log(25.0));
            this.setMaxWorldX(Math.log(22050.0));
            this.setMinWorldY(-43.0);
            this.setMaxWorldY(3.0);
        }

        @Override
        public void paint(Graphics g) {
            int width = this.bounds().width;
            int height = this.bounds().height;
            g.setColor(Color.cyan);
            g.fillRect(0, 0, width, height);
            g.setColor(Color.black);
            int numValues = FletcherMunson.this.ampFreqVector.size();
            if (numValues == 0) {
                return;
            }
            DFPair pair = (DFPair)FletcherMunson.this.ampFreqVector.firstElement();
            int x1 = this.convertWXtoGX(pair.getFrequency());
            int y1 = this.convertWYtoGY(pair.getdecibels());
            int i = 1;
            while (i < numValues) {
                DFPair nextPair = (DFPair)FletcherMunson.this.ampFreqVector.elementAt(i);
                g.fillOval(x1 - this.radius, y1 - this.radius, this.radius * 2, this.radius * 2);
                int x2 = this.convertWXtoGX(nextPair.getFrequency());
                int y2 = this.convertWYtoGY(nextPair.getdecibels());
                g.drawLine(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
                pair = nextPair;
                ++i;
            }
            g.fillOval(x1 - this.radius, y1 - this.radius, this.radius * 2, this.radius * 2);
        }
    }

    class DFPair {
        double decibels;
        double frequency;

        DFPair(double amp, double freq) {
            this.decibels = amp;
            this.frequency = freq;
        }

        double getdecibels() {
            return this.decibels;
        }

        double getFrequency() {
            return this.frequency;
        }
    }
}

