/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import compmus.Melody;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

class MelodyCanvas
extends Canvas {
    private static final long serialVersionUID = 1L;
    Melody melody;
    int index = 0;

    public MelodyCanvas(int index, Melody melody) {
        this.index = index;
        this.setMelody(melody);
    }

    void setMelody(Melody melody) {
        this.melody = melody;
        this.repaint();
    }

    Melody getMelody() {
        return this.melody;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 60);
    }

    @Override
    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        int totalDuration = 0;
        int minPitch = 999999999;
        int maxPitch = -999999999;
        int i = 0;
        while (i < this.melody.size()) {
            totalDuration += this.melody.getDuration(i);
            int pitch = this.melody.getPitch(i);
            if (pitch > maxPitch) {
                maxPitch = pitch;
            }
            if (pitch < minPitch) {
                minPitch = pitch;
            }
            ++i;
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        g.setColor(this.getForeground());
        g.drawRect(0, 0, width - 1, height - 1);
        g.drawString(Integer.toString(this.index), 5, 20);
        g.setColor(Color.blue);
        int beat = 0;
        int i2 = 0;
        while (i2 < this.melody.size()) {
            int x = width * beat / totalDuration;
            int pitch = this.melody.getPitch(i2);
            int y = (maxPitch - pitch) * height / (2 + maxPitch - minPitch);
            beat += this.melody.getDuration(i2);
            g.fillArc(x, y, 6, 6, 0, 360);
            ++i2;
        }
    }
}

