/*
 * Decompiled with CFR 0.152.
 */
package JSynTests;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.CrossFade;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthDistributor;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.SynthVariable;
import com.softsynth.jsyn.circuits.RingModBell;
import com.softsynth.jsyn.circuits.Swarm;
import com.softsynth.jsyn.view102.SoundTester;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GridLayout;

public class TJ_Nested
extends Applet {
    SynthCircuit mySound;
    LineOut myOut;

    public static void main(String[] args) {
        TJ_Nested applet = new TJ_Nested();
        AppletFrame frame = new AppletFrame("Test Nested", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            System.out.println("Try StartEngine");
            Synth.startEngine(0);
            Synth.verbosity = 0;
            this.mySound = new SwarmBell();
            this.myOut = new LineOut();
            this.mySound.output.connect(0, this.myOut.input, 0);
            this.mySound.output.connect(0, this.myOut.input, 1);
            this.add(new SoundTester(this.mySound));
            this.getParent().validate();
            this.getToolkit().sync();
            this.myOut.start();
            this.mySound.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.mySound.delete();
            this.mySound = null;
            this.myOut.delete();
            this.myOut = null;
            this.removeAll();
            Synth.verbosity = 0;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    class SwarmBell
    extends SynthNote {
        CrossFade unitFader = new CrossFade();
        SineOscillator unitLFO1;
        RingModBell ringBell;
        Swarm swarm;
        public SynthInput lfoRate;
        public SynthVariable halfLife;

        public SwarmBell() throws SynthException {
            this.add(this.unitFader);
            this.unitLFO1 = new SineOscillator();
            this.add(this.unitLFO1);
            this.swarm = new Swarm();
            this.add(this.swarm);
            this.ringBell = new RingModBell();
            this.add(this.ringBell);
            this.frequency = new SynthDistributor(this, "frequency", 2);
            this.amplitude = new SynthDistributor(this, "amplitude");
            this.lfoRate = this.unitLFO1.frequency;
            this.addPort(this.lfoRate, "lfoRate");
            this.halfLife = this.ringBell.halfLife;
            this.addPort(this.halfLife);
            this.output = this.unitFader.output;
            this.addPort(this.output);
            this.unitLFO1.output.connect(this.unitFader.fade);
            this.swarm.output.connect(0, this.unitFader.input, 0);
            this.ringBell.output.connect(0, this.unitFader.input, 1);
            this.frequency.connect(this.ringBell.frequency);
            this.frequency.connect(this.swarm.frequency);
            this.amplitude.connect(this.ringBell.amplitude);
            this.amplitude.connect(this.swarm.amplitude);
            this.frequency.setup(0.0, 100.0, 800.0);
            this.amplitude.setup(0.0, 0.6, 1.0);
            this.lfoRate.setup(0.0, 1.0, 20.0);
        }

        @Override
        public void setStage(int time, int stage) throws SynthException {
            this.ringBell.setStage(time, stage);
        }
    }
}

