/*
 * Decompiled with CFR 0.152.
 */
package JSynTests;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.view102.UsageDisplay;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Enumeration;
import java.util.Vector;

public class TJ_StressTest
extends Applet {
    Vector threads;
    MemMonitorThread memThread;

    public static void main(String[] args) {
        TJ_StressTest applet = new TJ_StressTest();
        AppletFrame frame = new AppletFrame("Test Threads", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        this.add(new UsageDisplay());
        this.getParent().validate();
        this.getToolkit().sync();
        int id = 0;
        this.threads = new Vector();
        double usage = 0.0;
        try {
            Synth.startEngine(0);
            while (usage < 0.9) {
                StressThread noodler = new StressThread();
                noodler.start();
                this.threads.addElement(noodler);
                Synth.sleepForTicks(100);
                usage = Synth.getUsage();
                System.out.println("XXX: id = " + id + ", Usage = " + usage);
                ++id;
            }
            this.memThread = new MemMonitorThread();
            this.memThread.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        this.memThread.stop();
        try {
            Enumeration e = this.threads.elements();
            while (e.hasMoreElements()) {
                StressThread noodler = (StressThread)e.nextElement();
                noodler.halt();
            }
            Synth.verbosity = 0;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    class MemMonitorThread
    extends Thread {
        MemMonitorThread() {
        }

        @Override
        public void run() {
            int seconds = 0;
            while (true) {
                try {
                    while (true) {
                        MemMonitorThread.sleep(1000L);
                        int numAllocs = Synth.debug(5, 0);
                        System.out.println("numAllocs = " + numAllocs + " after " + seconds + " seconds.");
                        ++seconds;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    class StressThread
    extends Thread {
        int tickNumber;
        int duration;
        int id;
        public SineOscillator myOsc = new SineOscillator();
        public LineOut myOut = new LineOut();
        boolean keepGoing;

        public StressThread() throws SynthException {
            this.myOsc.amplitude.set(0.01);
            this.myOsc.output.connect(0, this.myOut.input, 0);
            this.myOsc.output.connect(0, this.myOut.input, 1);
        }

        void stopSound() {
            try {
                this.myOut.stop();
                this.myOsc.stop();
            }
            catch (SynthException e) {
                System.err.println(e);
            }
        }

        @Override
        public void start() {
            this.keepGoing = true;
            super.start();
        }

        public void halt() {
            this.keepGoing = false;
            try {
                this.join();
            }
            catch (InterruptedException e) {
                System.err.println("halt got " + e);
            }
        }

        @Override
        public void run() {
            try {
                this.myOsc.frequency.set(0.0);
                this.myOut.start();
                this.myOsc.start();
                while (this.keepGoing) {
                    int sleepTime = 1 + (int)(Math.random() * 20.0);
                    Synth.sleepForTicks(sleepTime);
                    double frequency = Math.random() * 200.0 + 400.0;
                    int futureTime = Synth.getTickCount() + (int)(Math.random() * Synth.getTickRate());
                    this.myOsc.frequency.set(futureTime, frequency);
                }
            }
            catch (SynthException e) {
                System.err.println(e);
            }
            this.stopSound();
        }
    }
}

