/*
 * Decompiled with CFR 0.152.
 */
package berliner;

import berliner.BerlinerSamples;
import berliner.BerlinerVoice;
import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthMixer;
import com.softsynth.jsyn.util.StreamRecorder;
import com.softsynth.jsyn.util.WAVFileWriter;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.IOException;
import java.io.OutputStream;

public class Berliner
extends Applet {
    final boolean IF_RECORD_WAV = false;
    static final int NUM_VOICES = 3;
    BerlinerVoice[] voices;
    static final int FRAMES_PER_BUFFER = 8192;
    SynthMixer mixer;
    LineOut unitOut;
    static final double FRAME_RATE = 44100.0;
    static final int NUM_REC_CHANNELS = 2;
    StreamRecorder recorder;
    OutputStream outStream;
    WAVFileWriter waveWriter;

    public static void main(String[] args) {
        Berliner applet = new Berliner();
        AppletFrame frame = new AppletFrame("Berliner, by Phil Burk", applet);
        frame.setSize(600, 500);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        Synth.requestVersion(140);
        this.setLayout(new GridLayout(0, 1));
        this.voices = new BerlinerVoice[3];
        try {
            if (this.waveWriter != null) {
                this.waveWriter.writeHeader(2, 44100);
            }
            Synth.startEngine(0, 44100.0);
            this.mixer = new SynthMixer(3, 2);
            this.unitOut = new LineOut();
            this.mixer.getOutput(0).connect(0, this.unitOut.input, 0);
            this.mixer.getOutput(1).connect(0, this.unitOut.input, 1);
            this.mixer.start();
            this.unitOut.start();
            BerlinerSamples.loadTables();
            int i = 0;
            while (i < 3) {
                this.voices[i] = new BerlinerVoice();
                this.voices[i].start();
                if ((i & 1) != 0) {
                    this.voices[i].setBackground(Color.yellow);
                }
                this.add(this.voices[i]);
                this.mixer.connectInput(i, this.voices[i].output, 0);
                double leftGain = (double)i / 2.0;
                this.mixer.setGain(i, 0, leftGain);
                this.mixer.setGain(i, 1, 1.0 - leftGain);
                ++i;
            }
            this.getParent().validate();
            this.getToolkit().sync();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            if (this.recorder != null) {
                this.recorder.stop(Synth.getTickCount());
                this.outStream.flush();
                if (this.waveWriter != null) {
                    this.waveWriter.fixSizes();
                }
                this.outStream.close();
            }
            int i = 0;
            while (i < 3) {
                this.voices[i].stop();
                ++i;
            }
            this.removeAll();
            Synth.stopEngine();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

