/*
 * Decompiled with CFR 0.152.
 */
package berliner;

import berliner.BerlinerCircuit;
import berliner.BerlinerSamples;
import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.CrossFade;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthDistributor;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.TriangleOscillator;
import com.softsynth.jsyn.WaveShaper;

public class SampleWaveShaper
extends BerlinerCircuit {
    SineOscillator unitOsc;
    ExponentialLag unitLagFreq;
    ExponentialLag unitLagRange;
    ExponentialLag unitLagFade;
    TriangleOscillator unitTri;
    AddUnit unitSineOffset;
    WaveShaper[] unitWaveShapers;
    CrossFade unitFader;
    int curShaperIndex;
    double topFreq;
    int numSources = BerlinerSamples.names.length;
    int sourceIndex = 0;
    double freq = 100.0;
    double normalRange = 0.5;
    double rate = 0.1;
    SynthInput range;

    public SampleWaveShaper() throws SynthException {
        this.unitWaveShapers = new WaveShaper[2];
        this.unitOsc = new SineOscillator();
        this.add(this.unitOsc);
        this.unitLagFreq = new ExponentialLag();
        this.add(this.unitLagFreq);
        this.unitLagRange = new ExponentialLag();
        this.add(this.unitLagRange);
        this.unitLagFade = new ExponentialLag();
        this.add(this.unitLagFade);
        this.unitTri = new TriangleOscillator();
        this.add(this.unitTri);
        this.unitSineOffset = new AddUnit();
        this.add(this.unitSineOffset);
        this.unitWaveShapers[0] = new WaveShaper();
        this.add(this.unitWaveShapers[0]);
        this.unitWaveShapers[1] = new WaveShaper();
        this.add(this.unitWaveShapers[1]);
        this.unitFader = new CrossFade();
        this.add(this.unitFader);
        this.curShaperIndex = 0;
        this.frequency = this.unitLagFreq.input;
        this.addPort(this.frequency, "frequency");
        this.amplitude = new SynthDistributor(this, "amplitude");
        this.addPort(this.amplitude);
        this.output = this.unitFader.output;
        this.addPort(this.output);
        this.range = this.unitLagRange.input;
        this.addPort(this.range, "range");
        this.unitLagFreq.output.connect(this.unitOsc.frequency);
        this.unitLagRange.output.connect(this.unitOsc.amplitude);
        this.unitLagFade.output.connect(this.unitFader.fade);
        this.unitTri.output.connect(this.unitSineOffset.inputB);
        this.unitOsc.output.connect(this.unitSineOffset.inputA);
        this.unitSineOffset.output.connect(this.unitWaveShapers[0].input);
        this.unitSineOffset.output.connect(this.unitWaveShapers[1].input);
        this.unitWaveShapers[0].output.connect(0, this.unitFader.input, 0);
        this.unitWaveShapers[1].output.connect(0, this.unitFader.input, 1);
        this.unitLagRange.halfLife.set(0.05);
        this.unitLagFreq.halfLife.set(0.01);
        this.unitLagFade.halfLife.set(0.2);
        this.amplitude.connect(this.unitWaveShapers[0].amplitude);
        this.amplitude.connect(this.unitWaveShapers[1].amplitude);
        this.frequency.setup(0.0, 200.0, 800.0);
        this.amplitude.setup(0.0, 0.5, 1.0);
        this.range.setup(0.0, 0.01, 0.1);
        this.setSource(0);
        this.compile();
    }

    @Override
    public void setSource(int sourceIndex) throws SynthException {
        int nextShaperIndex = this.curShaperIndex == 0 ? 1 : 0;
        this.sourceIndex = sourceIndex;
        System.out.println("Use table " + sourceIndex + " on " + nextShaperIndex);
        this.unitWaveShapers[nextShaperIndex].tablePort.setTable(BerlinerSamples.tables[sourceIndex]);
        double fadeValue = nextShaperIndex == 0 ? -1.0 : 1.0;
        this.unitLagFade.input.set(fadeValue);
        this.updatePorts();
        this.curShaperIndex = nextShaperIndex;
    }

    @Override
    public void setGlideRate(double rate) throws SynthException {
        this.rate = rate;
        this.updatePorts();
    }

    @Override
    public int getNumParameters() {
        return 2;
    }

    @Override
    public String getParameterName(int index) {
        String name;
        switch (index) {
            case 0: {
                name = "Frequency";
                break;
            }
            case 1: {
                name = "Range";
                break;
            }
            default: {
                name = "OutOfRange!";
            }
        }
        return name;
    }

    void updatePorts() throws SynthException {
        this.frequency.set(this.freq);
        int tabLen = BerlinerSamples.tables[this.sourceIndex].length();
        double tableTime = (double)tabLen / Synth.getFrameRate();
        double minRange = 0.001 / tableTime;
        double newVal = minRange + this.normalRange * this.normalRange * 200.0 * minRange / (0.1 + this.freq);
        this.range.set(newVal);
        double triFreq = this.rate / tableTime;
        this.unitTri.frequency.set(triFreq);
    }

    void debug() throws SynthException {
        int tabLen = BerlinerSamples.tables[this.sourceIndex].length();
        System.out.println("Length = " + tabLen);
        System.out.println("sizeOffset = " + this.unitSineOffset.output.get());
    }

    @Override
    public void setParameter(int index, double value) throws SynthException {
        switch (index) {
            case 0: {
                this.freq = value * value * 500.0;
                break;
            }
            case 1: {
                this.normalRange = value;
                break;
            }
        }
        this.updatePorts();
    }
}

