/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.debug;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.LinearRamp;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.UnitOscillator;
import com.jsyn.util.WaveRecorder;
import java.io.File;
import java.io.IOException;

public class TestMidiGlitch {
    static final double SONG_DURATION = 4.0;
    private Synthesizer synth;
    private UnitOscillator osc;
    private LinearRamp ramp;
    private LineOut lineOut;
    private WaveRecorder recorder;
    private static final boolean useRecorder = true;
    private String[] filenames = new String[]{"fade_14bit.wav", "fade_7bit.wav", "fade_glitch.wav"};

    private void test(int strategy) throws IOException {
        this.synth = JSyn.createSynthesizer();
        this.synth.setRealTime(true);
        File waveFile = new File(this.filenames[strategy]);
        this.recorder = new WaveRecorder(this.synth, waveFile, 1, 24);
        System.out.println("Writing to WAV file " + waveFile.getAbsolutePath());
        this.osc = new SineOscillator();
        this.synth.add(this.osc);
        this.ramp = new LinearRamp();
        this.synth.add(this.ramp);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.ramp.output.connect(this.osc.amplitude);
        this.osc.output.connect(0, this.lineOut.input, 0);
        this.osc.output.connect(0, this.lineOut.input, 1);
        this.ramp.time.set(0.001);
        this.ramp.input.set(1.0);
        this.osc.frequency.set(220.0);
        this.synth.start();
        this.osc.output.connect(this.recorder.getInput());
        this.recorder.start();
        this.lineOut.start();
        double time = this.synth.getCurrentTime();
        double endAt = time + 4.0;
        double amplitude = 1.0;
        double period = 0.005;
        System.out.println("Sleep while the sound is being generated in the background.");
        try {
            while (time < endAt) {
                amplitude *= 0.99;
                switch (strategy) {
                    case 0: {
                        double quantized = this.quantize(amplitude, 14);
                        this.ramp.input.set(quantized, time);
                        break;
                    }
                    case 1: {
                        double quantized = this.quantize(amplitude, 7);
                        this.ramp.input.set(quantized, time);
                        break;
                    }
                    case 2: {
                        double quantized = this.quantize(amplitude, 7);
                        this.ramp.input.set(quantized, time);
                        quantized = this.quantize(amplitude, 14);
                        this.ramp.input.set(quantized, time + 0.001);
                    }
                }
                this.synth.sleepUntil((time += period) - 0.2);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.recorder != null) {
            this.recorder.stop();
            this.recorder.close();
        }
        this.synth.stop();
        System.out.println("Test complete.");
    }

    double quantize(double value, int bits) {
        double levels = 1 << bits;
        return (double)((int)Math.floor(value * levels)) / levels;
    }

    public static void main(String[] args) {
        try {
            new TestMidiGlitch().test(0);
            new TestMidiGlitch().test(1);
            new TestMidiGlitch().test(2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

