/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.engine;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.devices.AudioDeviceFactory;
import com.jsyn.unitgen.LineIn;
import com.jsyn.unitgen.LineOut;
import junit.framework.TestCase;

public class TestDevices
extends TestCase {
    public void testPassThrough() {
        Synthesizer synth = JSyn.createSynthesizer(AudioDeviceFactory.createAudioDeviceManager(true));
        LineIn lineIn = new LineIn();
        synth.add(lineIn);
        LineOut lineOut = new LineOut();
        synth.add(lineOut);
        lineIn.output.connect(0, lineOut.input, 0);
        lineIn.output.connect(1, lineOut.input, 1);
        int numInputChannels = 2;
        int numOutputChannels = 2;
        synth.start(44100, -1, numInputChannels, -1, numOutputChannels);
        lineOut.start();
        System.out.println("Audio passthrough started.");
        double sleepTime = 2.0;
        try {
            double time = synth.getCurrentTime();
            synth.sleepUntil(time + sleepTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        double synthTime = synth.getCurrentTime();
        TestDevices.assertEquals("Time has advanced. " + synthTime, sleepTime, synthTime, 0.2);
        synth.stop();
        System.out.println("All done.");
    }
}

