/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.pieces.improv;

import com.jsyn.pieces.improv.BeatDetector;
import com.jsyn.pieces.improv.Jammer;
import com.jsyn.pieces.improv.MusicBeat;
import java.util.HashMap;

public class BeatFollower
extends MusicBeat {
    private static final double PHASE_COEFFICIENT = 0.1;
    public HashMap<Jammer, BeatDetector> trackers = new HashMap();
    public double nextTime;
    private static final double STICKYNESS = 0.7;

    public BeatFollower(double period) {
        this.period = period;
    }

    public void hit(Jammer jammer, double time) {
        BeatDetector tracker = this.trackers.get(jammer);
        if (tracker == null) {
            tracker = new BeatDetector();
            this.trackers.put(jammer, tracker);
        }
        tracker.hit(time);
        if (tracker.getConfidence() > 0.5) {
            this.period = this.period * 0.7 + tracker.getPeriod() * 0.30000000000000004;
        }
        if (this.nextTime > time) {
            double error;
            double offset = this.nextTime - time;
            int offsetInBeats = (int)(offset / this.period);
            double beatOffset = offset - this.period * (double)offsetInBeats;
            if (beatOffset > this.period * 0.5) {
                error = (this.period - beatOffset) / this.period;
                this.period += error * 0.1;
                System.out.printf("UP, ", new Object[0]);
            } else {
                error = beatOffset / this.period;
                this.period -= error * 0.1;
                System.out.printf("DOWN, ", new Object[0]);
            }
            System.out.printf("beatOffset = %6.4f, error = %6.4f, ", beatOffset, error);
        }
    }
}

