/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.pieces.improv;

import com.jsyn.Synthesizer;
import com.jsyn.pieces.improv.BeatFollower;
import com.jsyn.pieces.improv.JamContext;
import com.jsyn.pieces.improv.JamContextListener;
import com.jsyn.util.PseudoRandom;
import com.jsyn.util.VoiceAllocator;
import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.shared.time.TimeStamp;

public class Jammer
implements Runnable,
JamContextListener {
    private Synthesizer synth;
    private VoiceAllocator allocator;
    private Thread thread;
    private volatile boolean go = false;
    private PseudoRandom pseudo = new PseudoRandom();
    private JamContext jamContext;
    private int noteNumber = 9;
    private static final int MAX_NOTES = 5;
    private static final int[] scale;
    private BeatFollower beatFollower = new BeatFollower(this.pseudo.random() * 0.4 + 0.2);
    private String name;

    static {
        int[] nArray = new int[5];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 7;
        nArray[4] = 9;
        scale = nArray;
    }

    public Jammer(String name, Synthesizer synth, VoiceAllocator allocator) {
        this.name = name;
        this.synth = synth;
        this.allocator = allocator;
        this.jamContext = JamContext.getInstance();
        this.pseudo.setSeed(this.hashCode());
        this.jamContext.addListener(this);
    }

    public void start() {
        this.stop();
        this.thread = new Thread(this);
        this.go = true;
        this.thread.start();
    }

    double indexToFrequency(int index) {
        int octave = index / scale.length;
        int temp = index % scale.length;
        int pitch = scale[temp] + 12 * octave;
        return EqualTemperedTuning.getMIDIFrequency(pitch + 28);
    }

    private void noteOff(double time, int noteNumber) {
        this.allocator.noteOff(noteNumber, new TimeStamp(time));
    }

    private void noteOn(double time, int noteNumber) {
        double frequency = this.indexToFrequency(noteNumber);
        double amplitude = 0.1;
        TimeStamp timeStamp = new TimeStamp(time);
        this.allocator.noteOn(noteNumber, frequency, amplitude, timeStamp);
        this.jamContext.notePlayed(this, time, noteNumber);
    }

    @Override
    public void run() {
        double advanceTime = 0.5;
        this.beatFollower.nextTime = this.synth.getCurrentTime() + advanceTime + this.pseudo.random();
        double onTime = this.beatFollower.period / 2.0;
        try {
            do {
                int pitch = this.noteNumber;
                this.noteOn(this.beatFollower.nextTime, pitch);
                this.noteOff(this.beatFollower.nextTime + onTime, pitch);
                this.beatFollower.nextTime += this.beatFollower.period;
                this.synth.sleepUntil(this.beatFollower.nextTime - advanceTime - this.pseudo.random() * 0.1);
            } while (this.go);
        }
        catch (InterruptedException e) {
            System.err.println("Song exiting. " + e);
        }
    }

    public void stop() {
        this.go = false;
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.thread = null;
        }
    }

    @Override
    public void notePlayed(Jammer jammer, double time, int noteNumber) {
        if (jammer != this) {
            if (this.noteNumber == noteNumber) {
                this.noteNumber = this.pseudo.choose(10) + 10;
            }
            this.beatFollower.hit(jammer, time);
            System.out.printf(String.valueOf(this.name) + ": period to %5.3f\n", this.beatFollower.period);
        }
    }
}

