/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.Synthesizer;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitPort;
import com.jsyn.swing.ASCIIMusicKeyboard;
import com.jsyn.swing.DoubleBoundedRangeSlider;
import com.jsyn.swing.PortControllerFactory;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSource;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.Instrument;
import com.softsynth.math.AudioMath;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SoundTweaker
extends JPanel {
    private UnitSource source;
    private ASCIIMusicKeyboard keyboard;
    private Synthesizer synth;
    static Logger logger = Logger.getLogger(SoundTweaker.class.getName());

    public SoundTweaker(Synthesizer synth, String title, UnitSource source) {
        this.synth = synth;
        this.source = source;
        this.setLayout(new GridLayout(0, 1));
        UnitGenerator ugen = source.getUnitGenerator();
        ArrayList<DoubleBoundedRangeSlider> sliders = new ArrayList<DoubleBoundedRangeSlider>();
        this.add(new JLabel(title));
        if (source instanceof Instrument) {
            this.keyboard = this.createPolyphonicKeyboard();
            this.add(this.keyboard);
        } else if (source instanceof UnitVoice) {
            this.keyboard = this.createMonophonicKeyboard();
            this.add(this.keyboard);
        }
        for (UnitPort unitPort : ugen.getPorts()) {
            if (!(unitPort instanceof UnitInputPort)) continue;
            UnitInputPort inputPort = (UnitInputPort)unitPort;
            DoubleBoundedRangeSlider slider = inputPort.getMinimum() > 0.0 && inputPort.getMaximum() / inputPort.getMinimum() > 4.0 ? PortControllerFactory.createExponentialPortSlider(inputPort) : PortControllerFactory.createPortSlider(inputPort);
            this.add(slider);
            sliders.add(slider);
        }
        if (this.keyboard != null) {
            for (Component component : sliders) {
                component.addKeyListener(this.keyboard.getKeyListener());
            }
        }
        this.validate();
    }

    private ASCIIMusicKeyboard createPolyphonicKeyboard() {
        ASCIIMusicKeyboard keyboard = new ASCIIMusicKeyboard(){

            @Override
            public void keyOff(int pitch) {
                logger.info("-------------- keyOff " + pitch);
                ((Instrument)((Object)SoundTweaker.this.source)).noteOff(pitch, SoundTweaker.this.synth.createTimeStamp());
            }

            @Override
            public void keyOn(int pitch) {
                logger.info("-------------- keyOn " + pitch);
                double freq = AudioMath.pitchToFrequency(pitch);
                ((Instrument)((Object)SoundTweaker.this.source)).noteOn(pitch, freq, 0.5, SoundTweaker.this.synth.createTimeStamp());
            }
        };
        return keyboard;
    }

    private ASCIIMusicKeyboard createMonophonicKeyboard() {
        ASCIIMusicKeyboard keyboard = new ASCIIMusicKeyboard(){

            @Override
            public void keyOff(int pitch) {
                ((UnitVoice)SoundTweaker.this.source).noteOff(SoundTweaker.this.synth.createTimeStamp());
            }

            @Override
            public void keyOn(int pitch) {
                double freq = AudioMath.pitchToFrequency(pitch);
                ((UnitVoice)SoundTweaker.this.source).noteOn(freq, 0.5, SoundTweaker.this.synth.createTimeStamp());
            }
        };
        return keyboard;
    }
}

