/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSource;
import com.jsyn.util.PseudoRandom;

public class BrownNoise
extends UnitGenerator
implements UnitSource {
    private PseudoRandom randomNum = new PseudoRandom();
    public UnitInputPort damping = new UnitInputPort("Damping");
    public UnitInputPort amplitude;
    public UnitOutputPort output;
    private double previous;

    public BrownNoise() {
        this.addPort(this.damping);
        this.damping.setup(1.0E-4, 0.01, 0.1);
        this.amplitude = new UnitInputPort("Amplitude", 0.999969482421875);
        this.addPort(this.amplitude);
        this.output = new UnitOutputPort("Output");
        this.addPort(this.output);
    }

    @Override
    public void generate(int start, int limit) {
        double[] amplitudes = this.amplitude.getValues();
        double[] outputs = this.output.getValues();
        double damper = 1.0 - this.damping.getValues()[0];
        int i = start;
        while (i < limit) {
            double r = this.randomNum.nextRandomDouble() * amplitudes[i];
            outputs[i] = this.previous = damper * this.previous + r;
            ++i;
        }
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.output;
    }
}

