/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.MixerMono;
import com.jsyn.unitgen.SineOscillator;

public class MixerStereo
extends MixerMono {
    public UnitInputPort pan;
    protected PanTracker[] panTrackers;

    public MixerStereo(int numInputs) {
        super(numInputs);
        this.pan = new UnitInputPort(numInputs, "Pan");
        this.addPort(this.pan);
        this.pan.setup(-1.0, 0.0, 1.0);
        this.panTrackers = new PanTracker[numInputs];
        int i = 0;
        while (i < numInputs) {
            this.panTrackers[i] = new PanTracker();
            ++i;
        }
    }

    @Override
    public int getNumOutputs() {
        return 2;
    }

    @Override
    public void generate(int start, int limit) {
        double[] amplitudes = this.amplitude.getValues(0);
        double[] outputs0 = this.output.getValues(0);
        double[] outputs1 = this.output.getValues(1);
        int i = start;
        while (i < limit) {
            double sum0 = 0.0;
            double sum1 = 0.0;
            int n = 0;
            while (n < this.input.getNumParts()) {
                double[] inputs = this.input.getValues(n);
                double[] gains = this.gain.getValues(n);
                double[] pans = this.pan.getValues(n);
                PanTracker panTracker = this.panTrackers[n];
                panTracker.update(pans[i]);
                double scaledInput = inputs[i] * gains[i];
                sum0 += scaledInput * panTracker.leftGain;
                sum1 += scaledInput * panTracker.rightGain;
                ++n;
            }
            double amp = amplitudes[i];
            outputs0[i] = sum0 * amp;
            outputs1[i] = sum1 * amp;
            ++i;
        }
    }

    static class PanTracker {
        double previousPan = Double.MAX_VALUE;
        double leftGain;
        double rightGain;

        PanTracker() {
        }

        public void update(double pan) {
            if (pan != this.previousPan) {
                double phase = pan * 0.25 + 0.25;
                this.leftGain = SineOscillator.fastSin(0.5 - phase);
                this.rightGain = SineOscillator.fastSin(phase);
                this.previousPan = pan;
            }
        }
    }
}

