/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.util.AutoCorrelator;
import com.jsyn.util.SignalCorrelator;
import com.jsynx.inprogress.FeatureCorrelator;
import junit.framework.TestCase;

public class TestAutoCorrelator
extends TestCase {
    private static final double TWO_PI = Math.PI * 2;

    public void testPeakInterpolation() {
        TestAutoCorrelator.assertEquals("flat left", -0.5, AutoCorrelator.interpolatePeak(0.7, 0.7, 0.6), 1.0E-4);
        TestAutoCorrelator.assertEquals("far left", -0.3, AutoCorrelator.interpolatePeak(0.6, 0.7, 0.2), 0.1);
        TestAutoCorrelator.assertEquals("middle left", -0.2, AutoCorrelator.interpolatePeak(0.6, 0.7, 0.5), 0.1);
        TestAutoCorrelator.assertEquals("middle", 0.0, AutoCorrelator.interpolatePeak(0.6, 0.7, 0.6), 1.0E-4);
        TestAutoCorrelator.assertEquals("middle right", 0.2, AutoCorrelator.interpolatePeak(0.5, 0.7, 0.6), 0.1);
        TestAutoCorrelator.assertEquals("far right", 0.3, AutoCorrelator.interpolatePeak(0.2, 0.7, 0.6), 0.1);
        TestAutoCorrelator.assertEquals("flat right", 0.5, AutoCorrelator.interpolatePeak(0.6, 0.7, 0.7), 1.0E-4);
        TestAutoCorrelator.assertEquals("flat right", 0.5, AutoCorrelator.interpolatePeak(0.6, 5.7, 5.7), 1.0E-4);
    }

    public void checkComplexWave(SignalCorrelator correlator, double period, double[] partials) {
        int bufferSize = 8192;
        int i = 0;
        while (i < bufferSize * 2) {
            correlator.addSample(0.0);
            ++i;
        }
        HarmonicWaveformGenerator gen = new HarmonicWaveformGenerator(period, partials);
        double periodSum = 0.0;
        double confidenceSum = 0.0;
        int updateCount = 0;
        int i2 = 0;
        while (i2 < bufferSize * 10) {
            double sample;
            if (i2 == 4089) {
                System.out.println("i = " + i2);
            }
            if (correlator.addSample(sample = gen.generate()) && (double)i2 > 10.0 * period) {
                ++updateCount;
                double confidence = correlator.getConfidence();
                TestAutoCorrelator.assertTrue("confidence = " + confidence, confidence > 0.1);
                double measured = correlator.getPeriod();
                periodSum += measured * correlator.getConfidence();
                confidenceSum += correlator.getConfidence();
                TestAutoCorrelator.assertEquals("instantaneous", period, measured, 0.05 * period);
            }
            ++i2;
        }
        double average = periodSum / confidenceSum;
        System.out.println("expected = " + period + ", average = " + average + ", ratio = " + period / average + ", updateCount = " + updateCount);
        TestAutoCorrelator.assertTrue("confidence", correlator.getConfidence() > 0.5);
    }

    private void checkSeries(SignalCorrelator correlator, double[] partials) {
        this.checkComplexWave(correlator, 100.0, partials);
        this.checkComplexWave(correlator, 100.1, partials);
        this.checkComplexWave(correlator, 100.5, partials);
        this.checkComplexWave(correlator, 100.9, partials);
        this.checkComplexWave(correlator, 101.0, partials);
        this.checkComplexWave(correlator, 101.2, partials);
        this.checkComplexWave(correlator, 101.7, partials);
        this.checkComplexWave(correlator, 492.1, partials);
        this.checkComplexWave(correlator, 234.5, partials);
        this.checkComplexWave(correlator, 123.4, partials);
        this.checkComplexWave(correlator, 34.7, partials);
    }

    public void checkSingleSine(SignalCorrelator correlator) {
        System.out.println("------------ single sine");
        double[] partials = new double[]{1.0};
        this.checkSeries(correlator, partials);
    }

    public void checkComplex1(SignalCorrelator correlator) {
        System.out.println("------------ typical harmonic");
        double[] partials = new double[]{1.0, 0.5, 0.3, 0.2, 0.1};
        this.checkSeries(correlator, partials);
    }

    public void checkSuboctave(SignalCorrelator correlator) {
        System.out.println("------------ strong second harmonic");
        double[] partials = new double[]{0.4, 1.0, 0.3, 0.2, 0.1};
        this.checkSeries(correlator, partials);
    }

    public void testAutoCorrelator() {
        AutoCorrelator auto = new AutoCorrelator(2048);
        this.checkSingleSine(auto);
        this.checkComplex1(auto);
        this.checkSuboctave(auto);
    }

    public void testFeatureCorrelator() {
        FeatureCorrelator auto = new FeatureCorrelator();
        this.checkSingleSine(auto);
        this.checkComplex1(auto);
        this.checkSuboctave(auto);
    }

    public static class HarmonicWaveformGenerator {
        private double[] mPhases;
        private double mPhaseIncrement;
        private double[] mPartials;

        HarmonicWaveformGenerator(double period, double[] partials) {
            this.mPhases = new double[partials.length];
            this.mPartials = partials;
            this.mPhaseIncrement = Math.PI * 2 / period;
        }

        double generate() {
            double sample = 0.0;
            int j = 0;
            while (j < this.mPartials.length) {
                sample += Math.sin(this.mPhases[j]) * this.mPartials[j];
                int n = j;
                this.mPhases[n] = this.mPhases[n] + (double)(j + 1) * this.mPhaseIncrement;
                while (this.mPhases[j] > Math.PI * 2) {
                    int n2 = j;
                    this.mPhases[n2] = this.mPhases[n2] - Math.PI * 2;
                }
                ++j;
            }
            return sample;
        }
    }
}

