/*
 * Decompiled with CFR 0.152.
 */
package com.jsynx.inprogress;

import com.jsyn.util.SignalCorrelator;

public class FeatureCorrelator
implements SignalCorrelator {
    private double period;
    private double confidence;
    private double score;
    private double newPeriod;
    private double maxPeriod = 2400.0;
    private double minPeriod = 18.0;
    private int countdown;
    private double previousLevel;
    private double previousSlope;
    private double previousMinimum;
    private double previousMaximum;
    private double hysteresisLevel;
    private HysteresisState hysteresisState;
    private int numFeatures;
    private int featureIndex;
    private short index;
    private static final int MAX_FEATURES_CONSIDER = 40;
    private static final int MINIMUM_FREQUENCY = 20;
    private static final int MAXIMUM_FREQUENCY = 2400;
    private static final int MAX_FEATURES = 256;
    private static final int MAX_FEATURE_MASK = 255;
    private FeatureRecord[] features = new FeatureRecord[256];
    static double[] periodScalers = new double[512];

    static {
        FeatureCorrelator.periodScalers[0] = 10.0;
        FeatureCorrelator.periodScalers[1] = 8.0;
        int i = 2;
        while (i < periodScalers.length) {
            double dbl_scaler;
            FeatureCorrelator.periodScalers[i] = dbl_scaler = 4.0 / Math.log(0.3 * (double)i);
            ++i;
        }
    }

    public FeatureCorrelator() {
        int i = 0;
        while (i < 256) {
            this.features[i] = new FeatureRecord();
            ++i;
        }
        this.hysteresisLevel = 0.01;
        this.newPeriod = this.period = 100.0;
    }

    private double calculatePeriod(FeatureRecord rec1, FeatureRecord rec2) {
        double period = rec2.position - rec1.position;
        int POSITION_RANGE = 65536;
        while (period < 0.0) {
            period += 65536.0;
        }
        return period;
    }

    private FeatureRecord GetNextFeatureRecord() {
        FeatureRecord rec = this.features[this.featureIndex++];
        this.featureIndex &= 0xFF;
        ++this.numFeatures;
        if (this.numFeatures >= 255) {
            this.numFeatures = 255;
        }
        return rec;
    }

    private double CorrelateXY(double x, double y) {
        double diff = x - y;
        return 1.0 - diff * diff * 0.5 / (x * x + y * y);
    }

    private int FindBestMatchingFeature(int matchThisIndex, int startIndex, int stopIndex, double candidatePeriod, ExtraParameter scoreParameter) {
        double score = 0.0;
        double bestScore = 0.0;
        int index = startIndex;
        int bestIndex = -1;
        FeatureRecord rec1 = this.features[matchThisIndex];
        while (index != stopIndex) {
            double periodX;
            FeatureRecord rec2 = this.features[index];
            if (rec1.type == rec2.type && (periodX = this.calculatePeriod(rec1, rec2)) >= 14.0 * candidatePeriod / 16.0 && periodX < 19.0 * candidatePeriod / 16.0) {
                double valueScore = this.CorrelateXY(rec1.value, rec2.value);
                double periodScore = this.CorrelateXY(periodX, candidatePeriod);
                score = (valueScore + periodScore) / 2.0;
                assert (score >= 0.0);
                if (score > bestScore) {
                    bestIndex = index;
                    bestScore = score;
                    scoreParameter.value = score;
                }
            }
            index = index - 1 & 0xFF;
        }
        return bestIndex;
    }

    private double AdjustScoreByPeriod(double score, double period) {
        int iperiod = (int)period;
        if (iperiod >= periodScalers.length) {
            iperiod = periodScalers.length - 1;
        }
        double scaler = 1.0;
        return score * scaler;
    }

    private double ConsiderCandidatePeriod(int topIndex, int candidateIndex, ExtraParameter candidatePeriodParameter) {
        double periodSum = 0.0;
        double averageScore = 0.0;
        int numFeaturesMatched = 0;
        double totalScore = 0.0;
        FeatureRecord candidateRec = this.features[candidateIndex];
        FeatureRecord topRec = this.features[topIndex];
        double candidatePeriod = this.calculatePeriod(candidateRec, topRec);
        if (candidatePeriod > this.maxPeriod) {
            return 0.0;
        }
        if (candidateRec.type == topRec.type && candidatePeriod > this.minPeriod) {
            int numFeaturesToMatch = topIndex - candidateIndex & 0xFF;
            ExtraParameter extra = new ExtraParameter();
            int i = 0;
            while (i < numFeaturesToMatch) {
                int index1 = candidateIndex - i & 0xFF;
                FeatureRecord rec1 = this.features[index1];
                int bestIndex = this.FindBestMatchingFeature(index1, topIndex, candidateIndex, candidatePeriod, extra);
                double score = extra.value;
                if (bestIndex >= 0 && score > 0.0) {
                    FeatureRecord bestRec = this.features[bestIndex];
                    double featurePeriod = this.calculatePeriod(rec1, bestRec);
                    double adjustedScore = this.AdjustScoreByPeriod(score, featurePeriod);
                    double weightedPeriod = featurePeriod * adjustedScore;
                    assert ((periodSum += weightedPeriod) >= 0.0);
                    totalScore += adjustedScore;
                    ++numFeaturesMatched;
                }
                ++i;
            }
        }
        if (totalScore > 0.0) {
            double averagePeriod = periodSum / totalScore;
            averageScore = totalScore / (double)numFeaturesMatched;
            double similarity = this.CorrelateXY(averagePeriod, this.period);
            double boost = this.score * similarity / 4.0;
            averageScore += boost;
            candidatePeriodParameter.value = averagePeriod;
        }
        return averageScore;
    }

    private void MatchFeatures() {
        double bestPeriod = this.maxPeriod;
        double bestScore = 0.0;
        if (this.numFeatures < 4) {
            return;
        }
        int topIndex = this.featureIndex - 1 & 0xFF;
        int numCheck = this.numFeatures / 2 < 40 ? this.numFeatures / 2 : 40;
        ExtraParameter candidatePeriodParameter = new ExtraParameter();
        int i = 1;
        while (i < numCheck) {
            double candidatePeriod = 0.0;
            int candidateIndex = topIndex - i & 0xFF;
            double candidateScore = this.ConsiderCandidatePeriod(topIndex, candidateIndex, candidatePeriodParameter);
            candidatePeriod = candidatePeriodParameter.value;
            if (candidateScore > 0.0 && candidateScore > bestScore) {
                bestScore = candidateScore;
                bestPeriod = candidatePeriod;
                assert (bestPeriod > 0.0);
            }
            ++i;
        }
        if (bestScore > 0.0) {
            if (bestPeriod > 7.0 * this.period / 8.0 && bestPeriod < 9.0 * this.period / 8.0 || bestPeriod > 7.0 * this.newPeriod / 8.0 && bestPeriod < 9.0 * this.newPeriod / 8.0 && bestScore > this.score / 4.0) {
                this.countdown = (int)Math.round(bestPeriod);
                this.period = bestPeriod;
                this.score = bestScore;
                this.confidence = this.calculateConfidence();
            }
            this.newPeriod = bestPeriod;
        }
    }

    private boolean checkZeroCrossing(double level, double slope) {
        boolean gotEdge = false;
        double delta = 0.0;
        if (this.hysteresisState == HysteresisState.GoingUp) {
            delta = level - this.hysteresisLevel;
            if (delta > 0.0) {
                this.hysteresisState = HysteresisState.GoingDown;
                gotEdge = true;
            }
        } else {
            delta = level - -this.hysteresisLevel;
            if (delta < 0.0) {
                this.hysteresisState = HysteresisState.GoingUp;
                gotEdge = true;
            }
        }
        if (gotEdge) {
            FeatureRecord rec = this.GetNextFeatureRecord();
            rec.value = slope * 10.0;
            rec.position = (double)this.index - delta / slope;
            rec.type = this.hysteresisState == HysteresisState.GoingDown ? FeatureType.RisingZeroCrossing : FeatureType.FallingZeroCrossing;
            this.MatchFeatures();
        }
        return gotEdge;
    }

    private void checkMinMax(double level, double slope) {
        if (slope < 0.0 ^ this.previousSlope < 0.0) {
            FeatureType type = FeatureType.Unspecified;
            if (slope > 0.0) {
                if (level < 7.0 * this.previousMaximum / 8.0) {
                    type = FeatureType.LocalMinimum;
                    this.previousMinimum = level;
                }
            } else if (level > 7.0 * this.previousMinimum / 8.0) {
                type = FeatureType.LocalMaximum;
                this.previousMaximum = level;
            }
            if (type != FeatureType.Unspecified) {
                double ds = slope - this.previousSlope;
                FeatureRecord rec = this.GetNextFeatureRecord();
                rec.value = level;
                rec.type = type;
                double delta = 0.0;
                if (Math.abs(ds) > 1.0E-8) {
                    delta = slope / ds;
                    assert (delta < 1.0);
                    assert (delta > -1.0);
                }
                rec.position = (double)this.index - delta;
            }
        }
    }

    @Override
    public boolean addSample(double level) {
        double slope = level - this.previousLevel;
        boolean result = this.checkZeroCrossing(level, slope);
        this.checkMinMax(level, slope);
        this.previousLevel = level;
        this.previousSlope = slope;
        this.index = (short)(this.index + 1);
        if (this.countdown <= 0) {
            this.score *= 0.998;
            this.confidence = this.calculateConfidence();
        } else {
            --this.countdown;
        }
        return result;
    }

    private double calculateConfidence() {
        double z = this.period * this.score;
        return z / (1.0 + z);
    }

    @Override
    public double getPeriod() {
        return this.period;
    }

    @Override
    public double getConfidence() {
        return this.confidence;
    }

    @Override
    public float[] getDiffs() {
        return null;
    }

    static class ExtraParameter {
        double value;

        ExtraParameter() {
        }
    }

    static class FeatureRecord {
        FeatureType type = FeatureType.Unspecified;
        double position;
        double value;

        FeatureRecord() {
        }
    }

    static enum FeatureType {
        Unspecified,
        RisingZeroCrossing,
        LocalMaximum,
        FallingZeroCrossing,
        LocalMinimum;

    }

    static enum HysteresisState {
        GoingUp,
        GoingDown;

    }
}

