/*
 * Decompiled with CFR 0.152.
 */
package com.jsynx.inprogress;

import com.jsyn.midi.MidiConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JComponent;

public class SlidingPitchDisplay
extends JComponent {
    private int lowPitch = 24;
    private int highPitch = 96;
    private double pitch = 60.0;
    private Image image;
    private double confidence = 1.0;

    public SlidingPitchDisplay() {
        this.setPreferredSize(new Dimension(400, 60));
        this.setForeground(Color.BLACK);
        this.setBackground(Color.YELLOW);
    }

    private void createPitchImage() {
        int h = this.getHeight();
        int w = 2 * (this.highPitch - this.lowPitch - 1) * h;
        int y = h * 3 / 4;
        this.image = this.createImage(w, h);
        Graphics g = this.image.getGraphics();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w, h);
        int[] nArray = new int[3];
        nArray[1] = w;
        nArray[2] = w;
        int[] xs = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = h;
        nArray2[1] = h;
        int[] ys = nArray2;
        g.setColor(Color.RED);
        g.fillPolygon(xs, ys, 3);
        g.setFont(new Font("Courier", 1, 28));
        int i = this.lowPitch;
        while (i < this.highPitch) {
            String pitchName = String.valueOf(MidiConstants.PITCH_NAMES[i % 12]) + i / 12;
            int x = this.pitchToX(i);
            g.setColor(Color.LIGHT_GRAY);
            g.drawLine(x, 0, x, h);
            g.setColor(Color.BLACK);
            g.drawString(pitchName, x - 12, y);
            ++i;
        }
    }

    private int pitchToX(double pitch) {
        int w = this.image.getWidth(this);
        int x = (int)Math.round((pitch - (double)this.lowPitch) * (double)w / (double)(this.highPitch - this.lowPitch));
        return x;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            this.createPitchImage();
        }
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w, h);
        int center = w / 2;
        int x = center - this.pitchToX(this.pitch);
        g.drawImage(this.image, x, 0, this);
        g.setColor(Color.GREEN);
        g.drawLine(center, 0, center, h);
        int y = (int)((double)h * (0.95 - this.confidence));
        g.setColor(Color.BLUE);
        g.drawLine(0, y, w, y);
    }

    public void setPitch(double pitch) {
        this.pitch = pitch;
        this.repaint();
    }

    public void setConfidence(double confidence) {
        this.confidence = confidence;
        this.repaint();
    }
}

