/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.applets.tuning;

import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.SawtoothOscillatorBL;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.SynthOscillator;

public class SimpleSawNote
extends SynthNote {
    public EnvelopePlayer envPlayer;
    public SynthEnvelope envelope;
    public SynthOscillator osc;
    int numFrames;
    public SynthInput rate;

    public SimpleSawNote() throws SynthException {
        this(Synth.getSharedContext());
    }

    public SimpleSawNote(SynthContext synthContext) throws SynthException {
        super(synthContext);
        this.envPlayer = new EnvelopePlayer(synthContext);
        this.add(this.envPlayer);
        this.osc = new SawtoothOscillatorBL(synthContext);
        this.add(this.osc);
        double[] data = new double[]{0.1, 0.9, 0.1, 0.8, 0.5, 0.0};
        this.numFrames = data.length / 2;
        this.envelope = new SynthEnvelope(synthContext, data);
        this.envPlayer.output.connect(this.osc.amplitude);
        this.frequency = this.osc.frequency;
        this.addPort(this.frequency);
        this.amplitude = this.envPlayer.amplitude;
        this.addPort(this.amplitude);
        this.rate = this.envPlayer.rate;
        this.addPort(this.rate);
        this.output = this.osc.output;
        this.addPort(this.output);
        this.amplitude.setup(0.0, 0.3, 1.0);
        this.frequency.setup(0.0, 160.0, 2000.0);
        this.rate.set(1.0);
    }

    @Override
    public void setStage(int time, int stage) throws SynthException {
        switch (stage) {
            case 0: {
                this.envPlayer.envelopePort.clear(time);
                this.envPlayer.envelopePort.queue(time, this.envelope, 0, this.numFrames - 1);
                this.start(time);
                break;
            }
            case 1: {
                this.envPlayer.envelopePort.queue(time, this.envelope, this.numFrames - 1, 1, 16);
            }
        }
    }
}

