/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.install;

import java.awt.TextArea;
import java.io.OutputStream;

public class TextAreaOutputStream
extends OutputStream {
    TextArea textArea;
    boolean newLinePending = false;

    public TextAreaOutputStream(TextArea textArea) {
        this.textArea = textArea;
    }

    @Override
    public void write(int b) {
        String msg = "" + (char)b;
        if (this.textArea != null) {
            if (b == 13 || b == 10) {
                this.newLinePending = true;
            } else {
                if (this.newLinePending) {
                    this.textArea.appendText("\n");
                    this.newLinePending = false;
                }
                this.textArea.appendText(msg);
            }
        } else {
            System.out.print(msg);
        }
    }

    @Override
    public void write(byte[] b, int offset, int length) {
        String msg = new String(b, offset, length);
        if (this.textArea != null) {
            this.textArea.append(msg);
        } else {
            System.out.print(msg);
        }
    }
}

