/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SampleReader_16F1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthSampleWAV;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;

public class DebugRamona
extends TestCase {
    @Override
    protected void setUp() throws Exception {
        Synth.startEngine(4);
    }

    @Override
    protected void tearDown() throws Exception {
        Synth.stopEngine();
    }

    public void testFootTap() {
        SynthSampleWAV sample = null;
        int quarterNote = 800;
        int nextTime = 0;
        boolean startTime = false;
        int lastMoved = 0;
        LineOut lineOut = new LineOut();
        SampleReader_16F1 footPlayer = new SampleReader_16F1();
        footPlayer.output.connect(0, lineOut.input, 0);
        footPlayer.output.connect(0, lineOut.input, 1);
        footPlayer.amplitude.set(0.88);
        footPlayer.start();
        lineOut.start();
        try {
            FileInputStream stream = new FileInputStream("samples/wingtip.wav");
            sample = new SynthSampleWAV(stream);
            System.out.println("getNumFrames = " + sample.getNumFrames());
            ((InputStream)stream).close();
        }
        catch (IOException e) {
            System.err.println(" wingTip not loaded " + e);
        }
        int i = 0;
        while (i < 8) {
            footPlayer.samplePort.queue(sample);
            Synth.sleepUntilTick((nextTime += quarterNote) - 20);
            int framesMoved = footPlayer.samplePort.getNumFramesMoved();
            System.out.println("moved = " + framesMoved);
            int delta = framesMoved - lastMoved;
            DebugRamona.assertEquals("delta should be numFrames", sample.getNumFrames(), delta);
            lastMoved = framesMoved;
            ++i;
        }
        footPlayer.stop();
        lineOut.stop();
        footPlayer.delete();
        lineOut.delete();
    }
}

