/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthFilter;
import com.softsynth.jsyn.SynthInput;

public class InterpolatingDelayUnit
extends SynthFilter {
    public SynthInput delay = new SynthInput(this, "Delay");

    public InterpolatingDelayUnit(SynthContext synthContext, int calculationRate, double maxDelayTime) throws SynthException {
        super(synthContext, "Delay_Interpolated", calculationRate, (int)(0.5 + maxDelayTime * synthContext.getFrameRate()));
    }

    public InterpolatingDelayUnit(int calculationRate, double delayTime) throws SynthException {
        this(Synth.getSharedContext(), calculationRate, delayTime);
    }

    public InterpolatingDelayUnit(SynthContext synthContext, double delayTime) throws SynthException {
        this(synthContext, 0, delayTime);
    }

    public InterpolatingDelayUnit(double delayTime) throws SynthException {
        this(Synth.getSharedContext(), 0, delayTime);
    }

    public InterpolatingDelayUnit(SynthContext synthContext) throws SynthException {
        this(synthContext, 1.0);
    }

    public InterpolatingDelayUnit() throws SynthException {
        this(1.0);
    }
}

