/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.SynthContext;
import junit.framework.TestCase;

public class TestTimestamps
extends TestCase {
    SynthContext context;

    @Override
    protected void setUp() throws Exception {
        this.context = new SynthContext();
        this.context.initialize();
        this.context.start(4);
    }

    @Override
    protected void tearDown() throws Exception {
        this.context.stop();
    }

    public void testSetTwice() {
        AddUnit adder = new AddUnit(this.context);
        adder.start();
        adder.inputA.set(1.0);
        adder.inputB.set(2.0);
        this.context.sleepForTicks(1);
        TestTimestamps.assertEquals("set inputs of adder", 3.0, adder.output.get(), 1.0E-4);
        int now = this.context.getTickCount();
        int advance = 5;
        int future = now + advance;
        adder.inputA.set(future, 79.0);
        adder.inputA.set(future, 4.0);
        this.context.sleepForTicks(1);
        TestTimestamps.assertEquals("should use old value before timestamped set", 3.0, adder.output.get(), 1.0E-4);
        this.context.sleepUntilTick(future);
        TestTimestamps.assertEquals("should now be future time", future, this.context.getTickCount());
        TestTimestamps.assertEquals("should use old value before timestamped set", 3.0, adder.output.get(), 1.0E-4);
        this.context.sleepForTicks(1);
        TestTimestamps.assertEquals("should use new value", 6.0, adder.output.get(), 1.0E-4);
    }

    public void testSetAgainLater() {
        AddUnit adder = new AddUnit(this.context);
        adder.start();
        adder.inputA.set(1.0);
        adder.inputB.set(2.0);
        int now = this.context.getTickCount();
        int future = now + 5;
        adder.inputA.set(future += 4, 81.0);
        this.context.sleepUntilTick(future);
        TestTimestamps.assertEquals("should now be future time", future, this.context.getTickCount());
        adder.inputA.set(8.0);
        this.context.sleepForTicks(1);
        TestTimestamps.assertEquals("now using value from timestamp", 10.0, adder.output.get(), 1.0E-4);
    }

    public void testSetTogether() {
        AddUnit adder = new AddUnit(this.context);
        adder.start();
        adder.inputA.set(1.0);
        adder.inputB.set(2.0);
        this.context.sleepForTicks(1);
        TestTimestamps.assertEquals("set inputs of adder", 3.0, adder.output.get(), 1.0E-4);
        int now = this.context.getTickCount();
        int future = now + 5;
        adder.inputA.set(future, 7.0);
        adder.inputB.set(future, 4.0);
        this.context.sleepForTicks(1);
        TestTimestamps.assertEquals("should use old value before timestamped set", 3.0, adder.output.get(), 1.0E-4);
        this.context.sleepUntilTick(future);
        TestTimestamps.assertEquals("should now be future time", future, this.context.getTickCount());
        TestTimestamps.assertEquals("should use old value before timestamps set", 3.0, adder.output.get(), 1.0E-4);
        this.context.sleepForTicks(1);
        TestTimestamps.assertEquals("should use new value after timestamps set", 11.0, adder.output.get(), 1.0E-4);
    }

    public void checkSetSeries(boolean increasing) {
        int i;
        int[] nArray = new int[6];
        nArray[1] = 3;
        nArray[2] = 5;
        nArray[3] = 6;
        nArray[4] = 8;
        nArray[5] = 11;
        int[] times = nArray;
        double[] values = new double[]{1.3, 5.2, 2.7, 3.9, 4.6, 7.9};
        AddUnit adder = new AddUnit(this.context);
        adder.start();
        double aValue = 1.0;
        adder.inputA.set(aValue);
        int startTime = this.context.getTickCount();
        if (increasing) {
            i = 0;
            while (i < times.length) {
                adder.inputB.set(startTime + times[i], values[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < times.length) {
                int index = times.length - 1 - i;
                adder.inputB.set(startTime + times[index], values[index]);
                ++i;
            }
        }
        i = 0;
        while (i < times.length) {
            this.context.sleepUntilTick(startTime + times[i] + 1);
            TestTimestamps.assertEquals("using value from timestamp for time " + times[i], aValue + values[i], adder.output.get(), 1.0E-4);
            ++i;
        }
    }

    public void testSetSeriesUp() {
        this.checkSetSeries(true);
    }

    public void testSetSeriesDown() {
        this.checkSetSeries(false);
    }
}

