/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthEnvelopeQueue;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.circuits.FMPair;

public class FMPairEnv
extends FMPair {
    public SynthEnvelope modAmpEnv;
    EnvelopePlayer modEnvPlayer;
    public SynthEnvelope amplitudeEnv;
    EnvelopePlayer carEnvPlayer;
    public SynthEnvelopeQueue modAmpEnvPort;
    public SynthEnvelopeQueue amplitudeEnvPort;

    @Override
    void makeCircuit() {
        super.makeCircuit();
        this.modEnvPlayer = new EnvelopePlayer();
        this.add(this.modEnvPlayer);
        this.carEnvPlayer = new EnvelopePlayer();
        this.add(this.carEnvPlayer);
        this.modEnvPlayer.output.connect(this.modOsc.amplitude);
        this.carEnvPlayer.output.connect(this.carOsc.amplitude);
        this.modAmplitude = this.modEnvPlayer.amplitude;
        this.amplitude = this.carEnvPlayer.amplitude;
        this.modAmpEnvPort = this.modEnvPlayer.envelopePort;
        this.amplitudeEnvPort = this.carEnvPlayer.envelopePort;
        double[] data = new double[]{0.05, 1.0, 0.3, 0.2, 0.3, 0.0};
        this.modAmpEnv = new SynthEnvelope(data);
        this.amplitudeEnv = new SynthEnvelope(data);
        this.modAmplitude.setup(0.0, 500.0, 10000.0);
        this.amplitude.setup(0.0, 0.5, 1.0);
    }

    @Override
    void addAllPorts() {
        super.addAllPorts();
        this.addPort(this.modAmpEnvPort, "modAmpEnv");
        this.addPort(this.amplitudeEnvPort, "amplitudeEnv");
    }

    @Override
    public void setStage(int time, int stage) throws SynthException {
        if (stage == 0) {
            this.modAmpEnvPort.clear(time);
            this.modAmpEnvPort.queue(time, this.modAmpEnv);
            this.amplitudeEnvPort.clear(time);
            this.amplitudeEnvPort.queue(time, this.amplitudeEnv);
        }
    }
}

