/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.EnvelopePoints;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.view11x.EditListener;
import com.softsynth.jsyn.view11x.EnvelopeEditor;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class TJ_EnvEdit1
extends Applet
implements EditListener {
    LineOut lineOut;
    SineOscillator osc;
    EnvelopeEditor envEditor;
    SynthEnvelope envelope;
    EnvelopePlayer envPlayer;
    EnvelopePoints points;
    final int MAX_FRAMES = 16;
    Button queueButton;
    Button queueLoopButton;
    Button clearButton;
    boolean looping = false;

    public static void main(String[] args) {
        TJ_EnvEdit1 applet = new TJ_EnvEdit1();
        AppletFrame frame = new AppletFrame("Test EnvelopeEditor", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        Synth.requestVersion(141);
        this.setLayout(new BorderLayout());
        try {
            Synth.startEngine(0);
            this.envelope = new SynthEnvelope(16);
            this.envPlayer = new EnvelopePlayer();
            this.osc = new SineOscillator();
            this.lineOut = new LineOut();
            this.envPlayer.output.connect(0, this.osc.amplitude, 0);
            this.osc.output.connect(0, this.lineOut.input, 0);
            this.osc.output.connect(0, this.lineOut.input, 1);
            this.osc.frequency.set(400.0);
            this.envEditor = new EnvelopeEditor();
            this.add("Center", this.envEditor);
            this.envEditor.setBackground(Color.cyan.brighter());
            this.envEditor.addEditListener(this);
            this.points = new EnvelopePoints();
            this.points.setName(this.osc.amplitude.getName());
            this.points.add(0.5, 1.0);
            this.points.add(0.5, 0.2);
            this.points.add(0.5, 0.8);
            this.points.add(0.5, 0.0);
            this.updateEnvelope();
            this.envEditor.setPoints(this.points);
            this.envEditor.setMaxPoints(16);
            Panel buttonPanel = new Panel();
            this.add((Component)buttonPanel, "South");
            this.queueButton = new Button("Queue");
            buttonPanel.add(this.queueButton);
            this.queueButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TJ_EnvEdit1.this.doQueue();
                }
            });
            this.queueLoopButton = new Button("QueueLoop");
            buttonPanel.add(this.queueLoopButton);
            this.queueLoopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TJ_EnvEdit1.this.doQueueLoop();
                }
            });
            this.clearButton = new Button("Clear");
            buttonPanel.add(this.clearButton);
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TJ_EnvEdit1.this.doClear();
                }
            });
            this.envPlayer.start();
            this.lineOut.start();
            this.osc.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.lineOut.delete();
            this.lineOut = null;
            this.osc.delete();
            this.osc = null;
            this.envPlayer.delete();
            this.envPlayer = null;
            this.removeAll();
            Synth.setTrace(0);
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void objectEdited(Object editor, Object objPoints) {
        if (this.looping) {
            this.doQueueLoop();
        }
    }

    public void updateEnvelope() {
        int numFrames = this.points.size();
        int i = 0;
        while (i < numFrames) {
            this.envelope.write(i, this.points.getPoint(i), 0, 1);
            ++i;
        }
    }

    public void doQueue() {
        this.updateEnvelope();
        this.envPlayer.envelopePort.queue(this.envelope, 0, this.points.size());
        this.looping = false;
    }

    public void doQueueLoop() {
        this.updateEnvelope();
        this.envPlayer.envelopePort.queueLoop(this.envelope, 0, this.points.size());
        this.looping = true;
    }

    public void doClear() {
        this.envPlayer.envelopePort.clear();
        this.looping = false;
    }
}

