/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SampleReader;
import com.softsynth.jsyn.SampleReader_16V1;
import com.softsynth.jsyn.SampleReader_16V2;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.SynthSampleAIFF;
import com.softsynth.jsyn.SynthSampleWAV;
import com.softsynth.jsyn.view102.PortFader;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class TJ_Sample2
extends Applet {
    public SynthSample mySamp;
    SampleReader mySampler;
    SynthInput ratePort;
    LineOut myOut;
    Button hitButton;
    Button onButton;
    Button offButton;
    int lastKeyDown = -1;
    int lastKeyPlayed = -1;
    double basePitch;
    boolean ifApplication = false;
    InputStream stream;
    final int NUM_FRAMES = 64;
    public String fileName = "samples/sine_200_300_stereo.wav";
    static String keyboard = "zxcvbnmasdfghqwerty123456";

    public static void main(String[] args) {
        TJ_Sample2 applet = new TJ_Sample2();
        if (args.length > 0) {
            applet.fileName = args[0];
        }
        applet.ifApplication = true;
        AppletFrame frame = new AppletFrame("Test SynthSample", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            Synth.verbosity = 0;
            try {
                if (this.ifApplication) {
                    File siteDir = new File("/Users/phil/Documents/workspace/JSynCode/");
                    File file = new File(siteDir, this.fileName);
                    this.stream = new FileInputStream(file);
                } else {
                    System.out.println("CodeBase = " + this.getCodeBase());
                    System.out.println("Path = " + this.getCodeBase());
                    URL sampleURL = new URL(this.getCodeBase(), this.fileName);
                    this.stream = sampleURL.openConnection().getInputStream();
                }
                switch (SynthSample.getFileType(this.fileName)) {
                    case 1: {
                        this.mySamp = new SynthSampleAIFF();
                        break;
                    }
                    case 2: {
                        this.mySamp = new SynthSampleWAV();
                        break;
                    }
                    default: {
                        SynthAlert.showError((Component)this, "Unrecognized sample file suffix.");
                    }
                }
                if (this.mySamp != null) {
                    this.loadSample(this.mySamp, this.stream);
                }
                this.stream.close();
            }
            catch (IOException e) {
                SynthAlert.showError((Component)this, e);
            }
            catch (SecurityException e) {
                SynthAlert.showError((Component)this, e);
            }
            this.myOut = new LineOut();
            if (this.mySamp.getChannelsPerFrame() == 1) {
                SampleReader_16V1 monoSampler = new SampleReader_16V1();
                this.ratePort = monoSampler.rate;
                this.mySampler = monoSampler;
                this.mySampler.output.connect(0, this.myOut.input, 0);
            } else if (this.mySamp.getChannelsPerFrame() == 2) {
                SampleReader_16V2 stereoSampler = new SampleReader_16V2();
                this.ratePort = stereoSampler.rate;
                this.mySampler = stereoSampler;
                this.mySampler.output.connect(0, this.myOut.input, 0);
                this.mySampler.output.connect(1, this.myOut.input, 1);
            }
            this.basePitch = EqualTemperedTuning.getMIDIPitch(this.mySamp.getBaseFrequency());
            this.add(new Label("Play Keys: " + keyboard));
            Panel panel = new Panel();
            panel.setLayout(new GridLayout(1, 0));
            this.add(panel);
            this.hitButton = new Button("Hit");
            panel.add(this.hitButton);
            this.onButton = new Button("On");
            panel.add(this.onButton);
            this.offButton = new Button("Off");
            panel.add(this.offButton);
            this.add(new PortFader(this.mySampler.amplitude, 0.7, 0.0, 1.0));
            this.add(new PortFader(this.ratePort, 44100.0, 0.0, 88200.0));
            this.myOut.start();
            this.mySampler.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    public void loadSample(SynthSample sample, InputStream stream) throws IOException {
        sample.load(stream);
    }

    @Override
    public void stop() {
        try {
            this.mySampler.delete();
            this.mySampler = null;
            this.myOut.delete();
            this.myOut = null;
            this.removeAll();
            Synth.verbosity = 0;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    double convertPitchToRate(double pitch) {
        double frequency = EqualTemperedTuning.getMIDIFrequency(pitch);
        return this.mySamp.getSampleRate() * (frequency / this.mySamp.getBaseFrequency());
    }

    boolean setRateByKey(int key) throws SynthException {
        int idx = keyboard.indexOf(key);
        if (idx < 0) {
            return false;
        }
        double pitch = (double)(idx - 12) + this.basePitch;
        double srate = this.convertPitchToRate(pitch);
        this.ratePort.set(srate);
        return true;
    }

    @Override
    public boolean keyDown(Event evt, int key) {
        if (key != this.lastKeyDown) {
            this.lastKeyDown = key;
            try {
                if (this.setRateByKey(key)) {
                    this.mySampler.samplePort.queueOn(this.mySamp);
                    this.lastKeyPlayed = key;
                    return true;
                }
            }
            catch (SynthException e) {
                SynthAlert.showError((Component)this, e);
                return true;
            }
        }
        return super.keyDown(evt, key);
    }

    @Override
    public boolean keyUp(Event evt, int key) {
        if (this.lastKeyPlayed != -1) {
            this.lastKeyPlayed = -1;
            try {
                this.mySampler.samplePort.queueOff(this.mySamp);
                return true;
            }
            catch (SynthException e) {
                SynthAlert.showError((Component)this, e);
                return true;
            }
        }
        return super.keyUp(evt, key);
    }

    @Override
    public boolean action(Event evt, Object what) {
        block6: {
            block5: {
                try {
                    if (evt.target != this.hitButton) break block5;
                    this.mySampler.samplePort.queue(this.mySamp);
                    return true;
                }
                catch (SynthException e) {
                    SynthAlert.showError((Component)this, e);
                    return true;
                }
            }
            if (evt.target != this.onButton) break block6;
            this.mySampler.samplePort.queueOn(this.mySamp);
            return true;
        }
        if (evt.target == this.offButton) {
            this.mySampler.samplePort.queueOff(this.mySamp);
            return true;
        }
        return false;
    }
}

