/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SampleReader_16V1;
import com.softsynth.jsyn.SampleReader_16V2;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.SynthSampleAIFF;
import com.softsynth.jsyn.SynthSampleWAV;
import com.softsynth.tools.view.JAppletFrame;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JButton;

public class TJ_SampleFormats
extends JApplet {
    SampleReader_16V1 monoSampler;
    SampleReader_16V2 stereoSampler;
    AddUnit mixer;
    LineOut myOut;
    boolean ifApplication = false;
    SynthSample[] samples;
    final String SAMPLE_DIR_NAME = "E:\\nomad\\javasonics\\website\\samples";
    final String[] sampleNames = new String[]{"mono_sr22050_b16.wav", "mono_sr44100_b8.wav", "mono_sr44100_b16.wav", "mono_sr44100_b16.aiff", "stereo_sr11025_b16.wav", "stereo_sr22050_b16.aiff", "stereo_sr22050_b16.wav", "stereo_sr44100_b8.wav", "stereo_sr44100_b16.wav", "stereo_sr44100_b16.aiff", "stereo_sr48000_b16.wav"};

    public static void main(String[] args) {
        TJ_SampleFormats applet = new TJ_SampleFormats();
        applet.ifApplication = true;
        JAppletFrame frame = new JAppletFrame("Test SynthSample", applet);
        frame.setSize(600, 200);
        frame.show();
        frame.test();
    }

    SynthSample loadSample(String fileName) {
        SynthSample mySamp = null;
        InputStream stream = null;
        System.out.println("Loading: " + fileName);
        try {
            if (this.ifApplication) {
                File siteDir = new File("E:\\nomad\\javasonics\\website\\samples");
                File file = new File(siteDir, fileName);
                stream = new FileInputStream(file);
            } else {
                System.out.println("CodeBase = " + this.getCodeBase());
                System.out.println("Path = " + this.getCodeBase());
                URL sampleURL = new URL(this.getCodeBase(), fileName);
                stream = sampleURL.openConnection().getInputStream();
            }
            switch (SynthSample.getFileType(fileName)) {
                case 1: {
                    mySamp = new SynthSampleAIFF();
                    break;
                }
                case 2: {
                    mySamp = new SynthSampleWAV();
                    break;
                }
                default: {
                    SynthAlert.showError((Component)this, "Unrecognized sample file suffix.");
                }
            }
            if (mySamp != null) {
                this.loadSample(mySamp, stream);
            }
            ((InputStream)stream).close();
            System.out.println(mySamp.dump());
        }
        catch (IOException e) {
            System.out.println("Caught " + e);
        }
        catch (SecurityException e) {
            System.out.println("Caught " + e);
        }
        return mySamp;
    }

    void loadSamples() {
        this.samples = new SynthSample[this.sampleNames.length];
        int i = 0;
        while (i < this.sampleNames.length) {
            this.samples[i] = this.loadSample(this.sampleNames[i]);
            JButton button = new JButton(this.sampleNames[i]);
            SampleTracker tracker = new SampleTracker(this.samples[i]);
            button.addActionListener(tracker);
            this.getContentPane().add(button);
            ++i;
        }
    }

    void playSample(SynthSample sample) {
        if (sample.getChannelsPerFrame() == 1) {
            this.monoSampler.rate.set(sample.getSampleRate());
            this.monoSampler.samplePort.queue(sample);
            this.stereoSampler.samplePort.clear();
        } else {
            this.stereoSampler.rate.set(sample.getSampleRate());
            this.stereoSampler.samplePort.queue(sample);
            this.monoSampler.samplePort.clear();
        }
    }

    @Override
    public void start() {
        this.getContentPane().setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            this.monoSampler = new SampleReader_16V1();
            this.stereoSampler = new SampleReader_16V2();
            this.mixer = new AddUnit();
            this.myOut = new LineOut();
            this.monoSampler.output.connect(0, this.mixer.inputA, 0);
            this.stereoSampler.output.connect(0, this.mixer.inputB, 0);
            this.mixer.output.connect(0, this.myOut.input, 0);
            this.stereoSampler.output.connect(1, this.myOut.input, 1);
            this.myOut.start();
            this.monoSampler.start();
            this.stereoSampler.start();
            this.mixer.start();
            this.loadSamples();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    public void loadSample(SynthSample sample, InputStream stream) throws IOException {
        sample.load(stream);
    }

    @Override
    public void stop() {
        try {
            this.monoSampler.delete();
            this.stereoSampler.delete();
            this.mixer.delete();
            this.myOut.delete();
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    class SampleTracker
    implements ActionListener {
        SynthSample sample;

        public SampleTracker(SynthSample sample) {
            this.sample = sample;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TJ_SampleFormats.this.playSample(this.sample);
        }
    }
}

