/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.player;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.BusReader;
import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.SynthVariable;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Label;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JSynPlayer
extends Applet {
    Vector busWriters;
    BusReader busReader;
    LineOut lineOut;
    Hashtable sounds;
    int nextIndex = 0;

    public static void main(String[] args) {
        JSynPlayer applet = new JSynPlayer();
        AppletFrame frame = new AppletFrame("JSyn Player", applet);
        frame.resize(440, 200);
        frame.show();
        frame.test();
        applet.test();
    }

    @Override
    public void start() {
        this.sounds = new Hashtable();
        this.busWriters = new Vector();
        this.add(new Label("JSynPlayer - http://www.softsynth.com/"));
        try {
            Synth.requestVersion(142);
            Synth.startEngine(0);
            this.busReader = new BusReader();
            this.lineOut = new LineOut();
            this.busReader.setPriority(0);
            this.busReader.output.connect(0, this.lineOut.input, 0);
            this.busReader.output.connect(0, this.lineOut.input, 1);
            this.busReader.start();
            this.lineOut.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        this.removeAll();
        try {
            Enumeration enumer = this.sounds.elements();
            while (enumer.hasMoreElements()) {
                SynthCircuit synthCircuit = (SynthCircuit)enumer.nextElement();
            }
            this.busReader.delete();
            this.lineOut.delete();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    Object makeObject(String className) {
        Object obj = null;
        Class<?> c = null;
        try {
            c = Class.forName(className);
            try {
                obj = c.newInstance();
            }
            catch (InstantiationException e) {
                System.err.println("Could not instantiate " + className + e);
            }
            catch (IllegalAccessException e) {
                System.err.println("Illegal access to " + className + e);
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not find " + className);
        }
        return obj;
    }

    void test() {
        int badIndex = this.loadSound("com.softsynth.jsyn.nopackage.DoesNotExist");
        if (badIndex != -1) {
            System.err.println("Expected -1 for loading com.softsynth.jsyn.nopackage.DoesNotExist");
        }
        if ((badIndex = this.loadSound("com.softsynth.jsyn.AddUnit")) != -2) {
            System.err.println("Expected -2 for loading com.softsynth.jsyn.AddUnit");
        }
        int sawIndex = this.loadSound("com.softsynth.jsyn.circuits.FilteredSawtoothBL");
        this.noteOn(sawIndex, 60.0, 0.3);
        Synth.sleepForTicks(400);
        this.setPort(this.getTime(), sawIndex, "Frequency", 500.0);
        Synth.sleepForTicks(400);
        this.noteOff(sawIndex);
    }

    int convertTimeToTicks(double time) {
        return (int)(time * Synth.getTickRate());
    }

    public int loadSound(String className) {
        int index = -2;
        Object loadedObject = this.makeObject(className);
        if (loadedObject == null) {
            return -1;
        }
        if (loadedObject instanceof SynthCircuit) {
            SynthCircuit circuit = (SynthCircuit)loadedObject;
            index = this.nextIndex++;
            this.sounds.put(new Integer(index), circuit);
            BusWriter writer = new BusWriter();
            circuit.output.connect(writer.input);
            writer.busOutput.connect(this.busReader.busInput);
            this.busWriters.addElement(writer);
            writer.start();
            circuit.start();
        }
        return index;
    }

    public void unloadSound(int index) {
        SynthCircuit circuit = (SynthCircuit)this.sounds.get(new Integer(index));
        if (circuit != null) {
            circuit.delete();
            this.sounds.remove(new Integer(index));
        }
    }

    public double getTime() {
        double rate = Synth.getTickRate();
        if (rate == 0.0) {
            return 0.0;
        }
        return (double)Synth.getTickCount() / Synth.getTickRate();
    }

    public void noteOn(double time, int index, double pitch, double amplitude) {
        double frequency = EqualTemperedTuning.getMIDIFrequency(pitch);
        SynthNote voice = (SynthNote)this.sounds.get(new Integer(index));
        voice.noteOn(this.convertTimeToTicks(time), frequency, amplitude);
    }

    public void noteOff(double time, int index) {
        SynthNote voice = (SynthNote)this.sounds.get(new Integer(index));
        voice.noteOff(this.convertTimeToTicks(time));
    }

    public void noteOn(int index, double pitch, double amplitude) {
        this.noteOn(this.getTime(), index, pitch, amplitude);
    }

    public void noteOff(int index) {
        this.noteOff(this.getTime(), index);
    }

    public void setPort(int index, String portName, double value) {
        this.setPort(this.getTime(), index, portName, value);
    }

    public void setPort(double time, int index, String portName, double value) {
        SynthCircuit circuit = (SynthCircuit)this.sounds.get(new Integer(index));
        SynthVariable port = (SynthVariable)circuit.findNamedPort(portName);
        if (port == null) {
            System.err.println("Port " + portName + " not found!");
            return;
        }
        port.set(this.convertTimeToTicks(time), value);
    }
}

